/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StyleModelNameDialog
extends ValidatingTitleAreaDialog {
    IStylingManager styleManager = (IStylingManager)ZigguratInject.make(IStylingManager.class);
    private Text text;
    private String styleName;

    public StyleModelNameDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32992);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Style model name");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.text = new Text(container, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 2));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyleModelNameDialog.this.validateInput();
            }
        });
        return area;
    }

    protected void okPressed() {
        this.styleName = this.text.getText();
        super.okPressed();
    }

    private boolean isNameAlreadyUsed(String name) {
        EList list = this.styleManager.getStyling().getModels();
        boolean alreadyUsed = false;
        if (name != null && list != null) {
            for (StylingModel s : list) {
                if (!name.equals(s.getModeName())) continue;
                alreadyUsed = true;
                break;
            }
        }
        return alreadyUsed;
    }

    public String getStyleModelName() {
        return this.styleName;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                String newText = StyleModelNameDialog.this.text.getText();
                if (newText == null || newText.isEmpty()) {
                    return "Enter the name of the new styling model";
                }
                if (StyleModelNameDialog.this.isNameAlreadyUsed(newText)) {
                    return "This styling model's name is already used.";
                }
                return null;
            }
        };
    }
}

