/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.polarsys.reqcycle.inittypes.inittypes.Attribute;
import org.polarsys.reqcycle.inittypes.inittypes.FileType;
import org.polarsys.reqcycle.inittypes.inittypes.Requirement;
import org.polarsys.reqcycle.inittypes.inittypes.Type;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingModelFactory;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.typesmodel.handler.ITypeManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocUtils {
    static ITypeManager manager = (ITypeManager)ZigguratInject.make(ITypeManager.class);

    public static List<FileType> getAllFilesInProject() {
        List listDocumentTypes = manager.getFileTypes();
        return listDocumentTypes;
    }

    public static List<Type> getListTypes(String fileName) {
        List listTypes = manager.getAllTypesPerFileTypes(fileName);
        return listTypes;
    }

    public static Image getImage(String file) {
        Bundle bundle = Platform.getBundle((String)"org.polarsys.reqcycle.repository.connector.document");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/" + file), null);
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
        return image.createImage();
    }

    public static List<Requirement> finalListRequirement(List<Requirement> requirements, Collection<IType> confTypes) {
        ArrayList<Requirement> listReq = new ArrayList<Requirement>();
        for (Requirement reqIn : requirements) {
            for (IType reqConfType : confTypes) {
                if (!(reqConfType instanceof IRequirementType)) continue;
                IRequirementType reqConf = (IRequirementType)reqConfType;
                if (!reqIn.getNameReq().equals(reqConf.getName())) continue;
                Requirement reqOut = reqIn;
                ArrayList attributesIn = new ArrayList();
                ArrayList attributesConf = new ArrayList();
                attributesIn.addAll(reqIn.getAttributesReq());
                attributesConf.addAll((List)reqConf.getAttributes());
                for (Attribute attIn : attributesIn) {
                    boolean foundAtt = false;
                    for (IAttribute attConf : attributesConf) {
                        if (!attIn.getNameAttribute().equals(attConf.getName())) continue;
                        foundAtt = true;
                        break;
                    }
                    if (foundAtt) continue;
                    reqOut.getAttributesReq().remove((Object)attIn);
                }
                listReq.add(reqOut);
            }
        }
        return listReq;
    }

    public static Collection<MappingElement> mappingElements(List<Requirement> requirements, Collection<IType> confTypes) {
        ArrayList<MappingElement> mappingElements = new ArrayList<MappingElement>();
        ArrayList<Requirement> lstRequirements = new ArrayList<Requirement>();
        lstRequirements.addAll(DocUtils.finalListRequirement(requirements, confTypes));
        for (Requirement reqIn : lstRequirements) {
            MappingElement elementMapping = MappingModelFactory.eINSTANCE.createMappingElement();
            elementMapping.setDescription(reqIn.getNameReq());
            elementMapping.setSourceQualifier(reqIn.getRegexReq().getExpression());
            elementMapping.setTargetElement(reqIn.eClass());
            for (Attribute att : reqIn.getAttributesReq()) {
                MappingAttribute mappingAttribute = MappingModelFactory.eINSTANCE.createMappingAttribute();
                if (att.getRegexAttribute() != null) {
                    mappingAttribute.setSourceId(att.getRegexAttribute().getExpression());
                } else {
                    System.out.println("warning: attribute " + att.getNameAttribute() + " has no regex ");
                }
                mappingAttribute.setDescription(att.getNameAttribute());
                elementMapping.getAttributes().add((Object)mappingAttribute);
            }
            mappingElements.add(elementMapping);
        }
        return mappingElements;
    }
}

