/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.ui.handlers;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddBuilderAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        IStructuredSelection structured;
        if (this.selection instanceof IStructuredSelection && (structured = (IStructuredSelection)this.selection).getFirstElement() instanceof IProject) {
            IProject p = (IProject)structured.getFirstElement();
            this.addBuild(p);
        }
    }

    private void addBuild(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.polarsys.reqcycle.traceability.builder")) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName("org.polarsys.reqcycle.traceability.builder");
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                newCommands[newCommands.length - 1] = command;
                desc.setBuildSpec(newCommands);
                project.setDescription(desc, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

