/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.PropertyHook;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class PropertyHookList
extends Statement {
    private final ASTNode.NodeList<PropertyHook> hooks = new ASTNode.NodeList(HOOKS_PROPERTY);
    public static final ChildListPropertyDescriptor HOOKS_PROPERTY = new ChildListPropertyDescriptor(PropertyHookList.class, "hooks", PropertyHook.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(1);
        properyList.add(HOOKS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public PropertyHookList(AST ast) {
        super(ast);
    }

    public PropertyHookList(int start, int end, AST ast, List<PropertyHook> hooks) {
        super(start, end, ast);
        for (PropertyHook a : hooks) {
            this.hooks.add(a);
        }
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (PropertyHook node : this.hooks) {
            node.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (PropertyHook node : this.hooks) {
            node.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (PropertyHook node : this.hooks) {
            node.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<PropertyHookList");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (PropertyHook part : this.hooks) {
            part.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</PropertyHookList>\n");
    }

    @Override
    public int getType() {
        return 94;
    }

    public List<PropertyHook> hooks() {
        return this.hooks;
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == HOOKS_PROPERTY) {
            return this.hooks();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<PropertyHook> parts = ASTNode.copySubtrees(target, this.hooks());
        return new PropertyHookList(this.getStart(), this.getEnd(), target, parts);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

