/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class NamedExpression
extends VariableBase {
    private Expression expression;
    private String name;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(NamedExpression.class, "expression", Expression.class, true, true);
    public static final SimplePropertyDescriptor NAME_PROPERTY = new SimplePropertyDescriptor(NamedExpression.class, "name", String.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(EXPRESSION_PROPERTY);
        propertyList.add(NAME_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public NamedExpression(AST ast) {
        super(ast);
    }

    public NamedExpression(int start, int end, AST ast, String name, Expression expr) {
        super(start, end, ast);
        if (expr == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expr);
        this.setName(name);
    }

    public void setName(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(NAME_PROPERTY);
        this.name = value;
        this.postValueChange(NAME_PROPERTY);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.expression != null) {
            this.expression.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.expression != null) {
            this.expression.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.expression != null) {
            this.expression.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<NamedExpression");
        this.appendInterval(buffer);
        buffer.append(" name='").append(this.getName()).append('\'');
        buffer.append(">\n");
        if (this.expression != null) {
            this.expression.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</NamedExpression>");
    }

    @Override
    public int getType() {
        return 84;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expr = ASTNode.copySubtree(target, this.getExpression());
        NamedExpression result = new NamedExpression(this.getStart(), this.getEnd(), target, this.name, expr);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

