/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.internal.signing.ssh.SshCertificateUtils;
import org.eclipse.jgit.internal.signing.ssh.SshSignatureConstants;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.PasswordProviderWrapper;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.agent.SshAgentClient;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Signer;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProviderFactory;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSigner
implements Signer {
    private static final Logger LOG = LoggerFactory.getLogger(SshSigner.class);
    private static final String GIT_KEY_PREFIX = "key::";
    private static final int LINE_LENGTH = 75;

    public GpgSignature sign(Repository repository, GpgConfig config, byte[] data, PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException, IOException, UnsupportedSigningFormatException {
        Map.Entry rawSignature;
        PublicKeyIdentity identity;
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("SHA512").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedSigningFormatException(MessageFormat.format(SshdText.get().signUnknownHashAlgorithm, "SHA512"), (Throwable)e);
        }
        ByteArrayBuffer toSign = new ByteArrayBuffer();
        toSign.putRawBytes(SshSignatureConstants.MAGIC);
        toSign.putString("git");
        toSign.putUInt(0L);
        toSign.putString("sha512");
        toSign.putBytes(hash);
        String key = signingKey;
        if (StringUtils.isEmptyOrNull((String)key)) {
            key = config.getSigningKey();
        }
        if (StringUtils.isEmptyOrNull((String)key)) {
            key = SshSigner.defaultKeyCommand(repository, config);
        }
        try {
            identity = SshSigner.getIdentity(key, committer, credentialsProvider);
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedSigningFormatException(MessageFormat.format(SshdText.get().signPublicKeyError, key), (Throwable)e);
        }
        String algorithm = switch (algorithm = KeyUtils.getKeyType((Key)identity.getKeyIdentity().getPublic())) {
            case "ssh-dss", "ssh-dss-cert-v01@openssh.com" -> throw new UnsupportedSigningFormatException(SshdText.get().signInvalidKeyDSA);
            case "ssh-rsa" -> "rsa-sha2-512";
            case "ssh-rsa-cert-v01@openssh.com" -> "rsa-sha2-512-cert-v01@openssh.com";
        };
        try {
            rawSignature = identity.sign(null, algorithm, toSign.getCompactData());
        }
        catch (Exception e) {
            throw new UnsupportedSigningFormatException(SshdText.get().signSignatureError, (Throwable)e);
        }
        algorithm = (String)rawSignature.getKey();
        ByteArrayBuffer signature = new ByteArrayBuffer();
        signature.putRawBytes(SshSignatureConstants.MAGIC);
        signature.putUInt(1L);
        signature.putPublicKey(identity.getKeyIdentity().getPublic());
        signature.putString("git");
        signature.putUInt(0L);
        signature.putString("sha512");
        ByteArrayBuffer sig = new ByteArrayBuffer();
        sig.putString(KeyUtils.getSignatureAlgorithm((String)algorithm, (PublicKey)identity.getKeyIdentity().getPublic()));
        sig.putBytes((byte[])rawSignature.getValue());
        signature.putBytes(sig.getCompactData());
        return SshSigner.armor(signature.getCompactData());
    }

    /*
     * Exception decompiling
     */
    private static String defaultKeyCommand(@NonNull Repository repository, @NonNull GpgConfig config) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String toString(TemporaryBuffer b) {
        if (b != null) {
            try {
                return new String(b.toByteArray(4000), SystemReader.getInstance().getDefaultCharset());
            }
            catch (IOException e) {
                LOG.warn("{}", (Object)SshdText.get().signStderr, (Object)e);
            }
        }
        return "";
    }

    private static PublicKeyIdentity getIdentity(String signingKey, PersonIdent committer, CredentialsProvider credentials) throws CanceledException, GeneralSecurityException, IOException {
        OpenSshCertificate cert;
        String message;
        PrivateKey privateKey;
        PublicKey publicKey;
        block21: {
            if (StringUtils.isEmptyOrNull((String)signingKey)) {
                throw new IllegalArgumentException(SshdText.get().signNoSigningKey);
            }
            publicKey = null;
            privateKey = null;
            File keyFile = null;
            if (signingKey.startsWith(GIT_KEY_PREFIX)) {
                publicKey = PublicKeyEntry.parsePublicKeyEntry((String)signingKey.substring(GIT_KEY_PREFIX.length())).resolvePublicKey(null, Collections.emptyMap(), PublicKeyEntryResolver.FAILING);
            } else if (signingKey.startsWith("~/") || signingKey.startsWith("~" + File.separator)) {
                keyFile = new File(FS.DETECTED.userHome(), signingKey.substring(2));
            } else {
                try {
                    publicKey = PublicKeyEntry.parsePublicKeyEntry((String)signingKey).resolvePublicKey(null, Collections.emptyMap(), PublicKeyEntryResolver.FAILING);
                }
                catch (IllegalArgumentException e) {
                    keyFile = new File(signingKey);
                }
            }
            if (keyFile != null && keyFile.isFile()) {
                try {
                    publicKey = KeyUtils.loadPublicKey((Path)keyFile.toPath());
                    if (publicKey == null) {
                        throw new StreamCorruptedException();
                    }
                    if ((keyFile = SshSigner.getPrivateKeyFile(keyFile.getParentFile(), keyFile.getName())) == null) break block21;
                    try {
                        KeyPair pair = SshSigner.loadPrivateKey(keyFile.toPath(), credentials);
                        if (pair != null) {
                            PublicKey pk = pair.getPublic();
                            if (pk == null) {
                                privateKey = pair.getPrivate();
                            } else {
                                PublicKey original = publicKey;
                                if (publicKey instanceof OpenSshCertificate) {
                                    OpenSshCertificate cert2 = (OpenSshCertificate)publicKey;
                                    original = cert2.getCertPubKey();
                                }
                                if (KeyUtils.compareKeys((PublicKey)original, (PublicKey)pk)) {
                                    privateKey = pair.getPrivate();
                                }
                            }
                        }
                    }
                    catch (IOException pair) {}
                }
                catch (StreamCorruptedException e) {
                    KeyPair pair = SshSigner.loadPrivateKey(keyFile.toPath(), credentials);
                    if (pair == null) break block21;
                    publicKey = pair.getPublic();
                    privateKey = pair.getPrivate();
                }
            }
        }
        if (publicKey == null) {
            throw new IOException(MessageFormat.format(SshdText.get().signNoPublicKey, signingKey));
        }
        if (publicKey instanceof OpenSshCertificate && (message = SshCertificateUtils.verify(cert = (OpenSshCertificate)publicKey, committer.getWhenAsInstant())) != null) {
            throw new IOException(message);
        }
        if (privateKey == null) {
            return new AgentIdentity(publicKey);
        }
        return new KeyPairIdentity(new KeyPair(publicKey, privateKey));
    }

    private static File getPrivateKeyFile(File directory, String publicKeyName) {
        String privateKeyName;
        if (publicKeyName.endsWith(".pub") && !(privateKeyName = publicKeyName.substring(0, publicKeyName.length() - 4)).isEmpty()) {
            File keyFile = new File(directory, privateKeyName);
            if (keyFile.isFile()) {
                return keyFile;
            }
            if (privateKeyName.endsWith("-cert") && !(privateKeyName = privateKeyName.substring(0, privateKeyName.length() - 5)).isEmpty() && (keyFile = new File(directory, privateKeyName)).isFile()) {
                return keyFile;
            }
        }
        return null;
    }

    private static KeyPair loadPrivateKey(Path path, CredentialsProvider credentials) throws CanceledException, GeneralSecurityException, IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        KeyPairResourceParser parser = SecurityUtils.getKeyPairResourceParser();
        if (parser != null) {
            PasswordProviderWrapper provider = null;
            if (credentials != null) {
                provider = new PasswordProviderWrapper(() -> (KeyPasswordProvider)KeyPasswordProviderFactory.getInstance().apply(credentials));
            }
            try {
                Collection keyPairs = parser.loadKeyPairs(null, path, (FilePasswordProvider)provider, new OpenOption[0]);
                if (keyPairs.size() != 1) {
                    throw new GeneralSecurityException(MessageFormat.format(SshdText.get().signTooManyPrivateKeys, path));
                }
                return (KeyPair)keyPairs.iterator().next();
            }
            catch (AuthenticationCanceledException e) {
                throw new CanceledException(e.getMessage());
            }
        }
        return null;
    }

    private static GpgSignature armor(byte[] data) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            b.write(SshSignatureConstants.ARMOR_HEAD);
            b.write(10);
            String encoded = Base64.encodeBytes((byte[])data);
            int length = encoded.length();
            int column = 0;
            int i = 0;
            while (i < length) {
                b.write(encoded.charAt(i));
                if (++column == 75) {
                    b.write(10);
                    column = 0;
                }
                ++i;
            }
            if (column > 0) {
                b.write(10);
            }
            b.write(SshSignatureConstants.ARMOR_END);
            b.write(10);
            return new GpgSignature(b.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean canLocateSigningKey(Repository repository, GpgConfig config, PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException {
        String key = signingKey;
        if (key == null) {
            key = config.getSigningKey();
        }
        return !StringUtils.isEmptyOrNull((String)key) || !StringUtils.isEmptyOrNull((String)config.getSshDefaultKeyCommand());
    }

    private static class AgentIdentity
    extends KeyPairIdentity {
        AgentIdentity(PublicKey publicKey) {
            super(new KeyPair(publicKey, null));
        }

        @Override
        public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
            Connector connector;
            ConnectorFactory factory = ConnectorFactory.getDefault();
            Connector connector2 = connector = factory == null ? null : factory.create("", null);
            if (connector == null) {
                throw new IOException(SshdText.get().signNoAgent);
            }
            Throwable throwable = null;
            Object var7_8 = null;
            try (SshAgentClient agent = new SshAgentClient(connector);){
                return agent.sign(null, this.getKeyIdentity().getPublic(), algo, data);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class KeyPairIdentity
    implements PublicKeyIdentity {
        @NonNull
        private final KeyPair pair;

        KeyPairIdentity(@NonNull KeyPair pair) {
            this.pair = pair;
        }

        public KeyPair getKeyIdentity() {
            return this.pair;
        }

        public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
            BuiltinSignatures factory = BuiltinSignatures.fromFactoryName((String)algo);
            if (factory == null || !factory.isSupported()) {
                throw new GeneralSecurityException(MessageFormat.format(SshdText.get().signUnknownSignatureAlgorithm, algo));
            }
            Signature signer = (Signature)factory.create();
            signer.initSigner(null, this.pair.getPrivate());
            signer.update(null, data);
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory.getName(), signer.sign(null));
        }
    }
}

