/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.TypeWithProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

final class ObjectType
implements TypeWithProperties {
    private final NominalType nominalType;
    private final Namespace ns;
    private final FunctionType fn;
    private final boolean isLoose;
    private final PersistentMap<String, Property> props;
    private final ObjectKind objectKind;
    static final ObjectType TOP_OBJECT = ObjectType.makeObjectType(null, null, null, null, false, ObjectKind.UNRESTRICTED);
    static final ObjectType TOP_STRUCT = ObjectType.makeObjectType(null, null, null, null, false, ObjectKind.STRUCT);
    static final ObjectType TOP_DICT = ObjectType.makeObjectType(null, null, null, null, false, ObjectKind.DICT);
    private static final PersistentMap<String, Property> BOTTOM_MAP = PersistentMap.of("_", Property.make(JSType.BOTTOM, JSType.BOTTOM));
    private static final ObjectType BOTTOM_OBJECT = new ObjectType(null, BOTTOM_MAP, null, null, false, ObjectKind.UNRESTRICTED);
    private static final Property UNKNOWN_PROP = Property.make(JSType.UNKNOWN, null);
    private static NominalType builtinObject = null;

    private ObjectType(NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, Namespace ns, boolean isLoose, ObjectKind objectKind) {
        Preconditions.checkArgument((fn == null || fn.isQmarkFunction() || fn.isLoose() == isLoose ? 1 : 0) != 0, (String)"isLoose: %s, fn: %s", (Object[])new Object[]{isLoose, fn});
        Preconditions.checkArgument((boolean)FunctionType.isInhabitable(fn));
        Preconditions.checkArgument((fn == null || nominalType != null ? 1 : 0) != 0, (String)"Cannot create function %s without nominal type", (Object[])new Object[]{fn});
        if (ns != null && nominalType != null) {
            String name = nominalType.getName();
            Preconditions.checkArgument((name.equals("Object") || name.equals("Function") || name.equals("Window") ? 1 : 0) != 0, (String)"Can't create namespace with nominal type %s", (Object[])new Object[]{name});
        }
        if (nominalType != null) {
            Preconditions.checkArgument((!nominalType.isClassy() || !isLoose ? 1 : 0) != 0, (String)"Cannot create loose objectType with nominal type %s", (Object[])new Object[]{nominalType});
            Preconditions.checkArgument((fn == null || nominalType.isFunction() ? 1 : 0) != 0, (String)"Cannot create objectType of nominal type %s with function (%s)", (Object[])new Object[]{nominalType, fn});
        }
        this.nominalType = nominalType;
        this.props = isLoose ? ObjectType.loosenProps(props) : props;
        this.fn = fn;
        this.ns = ns;
        this.isLoose = isLoose;
        this.objectKind = isLoose ? ObjectKind.UNRESTRICTED : objectKind;
    }

    private static PersistentMap<String, Property> loosenProps(PersistentMap<String, Property> props) {
        PersistentMap<String, Property> newProps = props;
        for (Map.Entry entry : props.entrySet()) {
            JSType propType = ((Property)entry.getValue()).getType();
            ObjectType objType = propType.getObjTypeIfSingletonObj();
            if (objType == null || objType.getNominalType().isClassy() || objType.isLoose()) continue;
            newProps = newProps.with((String)entry.getKey(), Property.make(propType.withLoose(), null));
        }
        return newProps;
    }

    static ObjectType makeObjectType(NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, Namespace ns, boolean isLoose, ObjectKind ok) {
        if (props == null) {
            props = PersistentMap.create();
        } else if (ObjectType.containsBottomProp(props) || !FunctionType.isInhabitable(fn)) {
            return BOTTOM_OBJECT;
        }
        if (!(fn == null || props.containsKey("prototype") || ns != null && ns.getNsProp("prototype") != null)) {
            props = props.with("prototype", UNKNOWN_PROP);
        }
        return new ObjectType(nominalType, props, fn, ns, isLoose, ok);
    }

    static ObjectType fromFunction(FunctionType fn, NominalType fnNominal) {
        return ObjectType.makeObjectType(fnNominal, null, fn, null, fn.isLoose(), ObjectKind.UNRESTRICTED);
    }

    static ObjectType fromNominalType(NominalType cl) {
        return ObjectType.makeObjectType(cl, null, null, null, false, cl.getObjectKind());
    }

    static ObjectType fromProperties(Map<String, Property> oldProps) {
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> entry : oldProps.entrySet()) {
            Property prop = entry.getValue();
            if (prop.getDeclaredType().isBottom()) {
                return BOTTOM_OBJECT;
            }
            newProps = newProps.with(entry.getKey(), prop);
        }
        return new ObjectType(null, newProps, null, null, false, ObjectKind.UNRESTRICTED);
    }

    static void setObjectType(NominalType builtinObject) {
        ObjectType.builtinObject = builtinObject;
    }

    boolean isInhabitable() {
        return this != BOTTOM_OBJECT;
    }

    static boolean containsBottomProp(PersistentMap<String, Property> props) {
        for (Property p : props.values()) {
            if (!p.getType().isBottom()) continue;
            return true;
        }
        return false;
    }

    boolean isStruct() {
        return this.objectKind.isStruct();
    }

    boolean isLoose() {
        return this.isLoose;
    }

    boolean isDict() {
        return this.objectKind.isDict();
    }

    boolean isFunctionWithProperties() {
        return this.fn != null && this.hasNonPrototypeProperties();
    }

    boolean isInterfaceInstance() {
        return this.nominalType != null && this.nominalType.isInterface();
    }

    boolean isNamespace() {
        return this.ns != null;
    }

    private boolean hasNonPrototypeProperties() {
        for (String pname : this.props.keySet()) {
            if (pname.equals("prototype")) continue;
            return true;
        }
        return this.ns != null;
    }

    static ImmutableSet<ObjectType> withLooseObjects(Set<ObjectType> objs) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withLoose());
        }
        return newObjs.build();
    }

    private ObjectType withLoose() {
        if (this.isLoose() || this.nominalType != null && this.nominalType.isClassy() || this.ns != null) {
            return this;
        }
        FunctionType fn = this.fn == null ? null : this.fn.withLoose();
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry propsEntry : this.props.entrySet()) {
            String pname = (String)propsEntry.getKey();
            Property prop = (Property)propsEntry.getValue();
            newProps = newProps.with(pname, prop.withRequired());
        }
        return new ObjectType(this.nominalType, newProps, fn, null, true, this.objectKind);
    }

    ObjectType withFunction(FunctionType ft, NominalType fnNominal) {
        Preconditions.checkState((!this.isLoose ? 1 : 0) != 0);
        Preconditions.checkState((!ft.isLoose() || ft.isQmarkFunction() ? 1 : 0) != 0);
        return ObjectType.makeObjectType(fnNominal, this.props, ft, this.ns, false, this.objectKind);
    }

    static ImmutableSet<ObjectType> withoutProperty(Set<ObjectType> objs, QualifiedName qname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, null));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyHelper(QualifiedName qname, JSType type, boolean isDeclared, boolean isConstant) {
        PersistentMap<String, Property> newProps = this.props;
        if (qname.isIdentifier()) {
            String pname = qname.getLeftmostName();
            JSType declType = this.getDeclaredProp(qname);
            if (type == null) {
                type = declType;
            }
            if (declType != null) {
                isDeclared = true;
                if (this.hasConstantProp(qname)) {
                    isConstant = true;
                }
                if (type != null && !type.isSubtypeOf(declType, SubtypeCache.create())) {
                    type = declType;
                }
            } else if (isDeclared) {
                declType = type;
            }
            newProps = type == null && declType == null ? newProps.without(pname) : newProps.with(pname, isConstant ? Property.makeConstant(null, type, declType) : Property.make(type, isDeclared ? declType : null));
        } else {
            String objName = qname.getLeftmostName();
            QualifiedName objQname = new QualifiedName(objName);
            if (!this.mayHaveProp(objQname)) {
                Preconditions.checkState((type == null ? 1 : 0) != 0, (String)"Trying to update property %s on type %s, but sub-property %s does not exist", (Object[])new Object[]{qname, this, objName});
                return this;
            }
            QualifiedName innerProps = qname.getAllButLeftmost();
            Property objProp = this.getLeftmostProp(objQname);
            JSType inferred = type == null ? objProp.getType().withoutProperty(innerProps) : objProp.getType().withProperty(innerProps, type);
            JSType declared = objProp.getDeclaredType();
            newProps = newProps.with(objName, objProp.isOptional() ? Property.makeOptional(null, inferred, declared) : Property.make(inferred, declared));
        }
        return ObjectType.makeObjectType(this.nominalType, newProps, this.fn, this.ns, this.isLoose, this.objectKind);
    }

    ObjectType withProperty(QualifiedName qname, JSType type) {
        return this.withPropertyHelper(qname, type, false, false);
    }

    static ImmutableSet<ObjectType> withProperty(Set<ObjectType> objs, QualifiedName qname, JSType type) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, type));
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> withDeclaredProperty(Set<ObjectType> objs, QualifiedName qname, JSType type, boolean isConstant) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyHelper(qname, type, true, isConstant));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyRequired(String pname) {
        Property oldProp = (Property)this.props.get(pname);
        Property newProp = oldProp == null ? UNKNOWN_PROP : Property.make(oldProp.getType(), oldProp.getDeclaredType());
        return ObjectType.makeObjectType(this.nominalType, this.props.with(pname, newProp), this.fn, this.ns, this.isLoose, this.objectKind);
    }

    static ImmutableSet<ObjectType> withPropertyRequired(Set<ObjectType> objs, String pname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyRequired(pname));
        }
        return newObjs.build();
    }

    private static PersistentMap<String, Property> meetPropsHelper(boolean specializeProps1, NominalType resultNominalType, Namespace resultNs, PersistentMap<String, Property> props1, PersistentMap<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = props1;
        if (resultNominalType != null || resultNs != null) {
            for (Map.Entry propsEntry : props1.entrySet()) {
                pname = (String)propsEntry.getKey();
                Property otherProp = ObjectType.getPropHelper(pname, resultNs, resultNominalType);
                if (otherProp == null || (newProps = ObjectType.addOrRemoveProp(specializeProps1, newProps, pname, otherProp, (Property)propsEntry.getValue())) != BOTTOM_MAP) continue;
                return BOTTOM_MAP;
            }
        }
        for (Map.Entry propsEntry : props2.entrySet()) {
            Property newProp;
            pname = (String)propsEntry.getKey();
            Property prop2 = (Property)propsEntry.getValue();
            if (!props1.containsKey(pname)) {
                newProp = prop2;
            } else {
                Property prop1 = (Property)props1.get(pname);
                if (prop1.equals(prop2)) continue;
                newProp = specializeProps1 ? prop1.specialize(prop2) : Property.meet(prop1, prop2);
            }
            Property otherProp = ObjectType.getPropHelper(pname, resultNs, resultNominalType);
            if (otherProp != null) {
                if ((newProps = ObjectType.addOrRemoveProp(specializeProps1, newProps, pname, otherProp, newProp)) != BOTTOM_MAP) continue;
                return BOTTOM_MAP;
            }
            if (newProp.getType().isBottom()) {
                return BOTTOM_MAP;
            }
            newProps = newProps.with(pname, newProp);
        }
        return newProps;
    }

    private static PersistentMap<String, Property> addOrRemoveProp(boolean specializeProps1, PersistentMap<String, Property> props, String pname, Property nomProp, Property objProp) {
        JSType nomPropType = nomProp.getType();
        Property newProp = specializeProps1 ? nomProp.specialize(objProp) : Property.meet(nomProp, objProp);
        JSType newPropType = newProp.getType();
        if (newPropType.isBottom()) {
            return BOTTOM_MAP;
        }
        if (!newPropType.isUnknown() && newPropType.isSubtypeOf(nomPropType, SubtypeCache.create()) && !newPropType.equals(nomPropType)) {
            return props.with(pname, newProp);
        }
        return props.without(pname);
    }

    private static Property getProp(Map<String, Property> props, NominalType nom, String pname) {
        if (props.containsKey(pname)) {
            return props.get(pname);
        }
        if (nom != null) {
            return nom.getProp(pname);
        }
        return null;
    }

    private static PersistentMap<String, Property> joinProps(Map<String, Property> props1, Map<String, Property> props2, NominalType nom1, NominalType nom2) {
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String pname : Sets.union(props1.keySet(), props2.keySet())) {
            Property prop1 = ObjectType.getProp(props1, nom1, pname);
            Property prop2 = ObjectType.getProp(props2, nom2, pname);
            Property newProp = null;
            newProp = prop1 == null ? prop2.withOptional() : (prop2 == null ? prop1.withOptional() : Property.join(prop1, prop2));
            newProps = newProps.with(pname, newProp);
        }
        return newProps;
    }

    private static PersistentMap<String, Property> joinPropsLoosely(Map<String, Property> props1, Map<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> propsEntry : props1.entrySet()) {
            pname = propsEntry.getKey();
            if (!props2.containsKey(pname)) {
                newProps = newProps.with(pname, propsEntry.getValue().withRequired());
            }
            if (newProps != BOTTOM_MAP) continue;
            return BOTTOM_MAP;
        }
        for (Map.Entry<String, Property> propsEntry : props2.entrySet()) {
            pname = propsEntry.getKey();
            Property prop2 = propsEntry.getValue();
            newProps = props1.containsKey(pname) ? newProps.with(pname, Property.join(props1.get(pname), prop2).withRequired()) : newProps.with(pname, prop2.withRequired());
            if (newProps != BOTTOM_MAP) continue;
            return BOTTOM_MAP;
        }
        return newProps;
    }

    static boolean isUnionSubtype(boolean keepLoosenessOfThis, Set<ObjectType> objs1, Set<ObjectType> objs2, SubtypeCache subSuperMap) {
        for (ObjectType obj1 : objs1) {
            boolean foundSupertype = false;
            for (ObjectType obj2 : objs2) {
                if (!obj1.isSubtypeOfHelper(keepLoosenessOfThis, obj2, subSuperMap)) continue;
                foundSupertype = true;
                break;
            }
            if (foundSupertype) continue;
            return false;
        }
        return true;
    }

    boolean isSubtypeOf(ObjectType obj2, SubtypeCache subSuperMap) {
        return this.isSubtypeOfHelper(true, obj2, subSuperMap);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, ObjectType other, SubtypeCache subSuperMap) {
        Object otherPropNames;
        if (other == TOP_OBJECT) {
            return true;
        }
        if (keepLoosenessOfThis && this.isLoose || other.isLoose) {
            return this.isLooseSubtypeOf(other, subSuperMap);
        }
        NominalType thisNt = this.nominalType;
        NominalType otherNt = other.nominalType;
        boolean checkOnlyLocalProps = true;
        if (otherNt != null && otherNt.isStructuralInterface()) {
            if (otherNt.equals(subSuperMap.get(thisNt))) {
                return true;
            }
            subSuperMap = subSuperMap.with(thisNt, otherNt);
            if (thisNt == null || !thisNt.isNominalSubtypeOf(otherNt)) {
                checkOnlyLocalProps = false;
            }
        } else if (!(otherNt == null || otherNt.isStructuralInterface() || thisNt != null && thisNt.isNominalSubtypeOf(otherNt))) {
            return false;
        }
        if (checkOnlyLocalProps) {
            otherPropNames = other.props.keySet();
        } else {
            otherPropNames = otherNt.getAllPropsOfInterface();
            if (otherPropNames == null) {
                return false;
            }
        }
        if (!this.arePropertiesSubtypes(other, (Set<String>)otherPropNames, subSuperMap)) {
            return false;
        }
        if (other.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        return this.fn.isSubtypeOf(other.fn, subSuperMap);
    }

    private boolean arePropertiesSubtypes(ObjectType other, Set<String> otherPropNames, SubtypeCache subSuperMap) {
        QualifiedName qname;
        for (String pname : otherPropNames) {
            qname = new QualifiedName(pname);
            if (ObjectType.isPropertySubtype(this.getLeftmostProp(qname), other.getLeftmostProp(qname), subSuperMap)) continue;
            return false;
        }
        if (other.ns != null) {
            for (String pname : other.ns.getAllPropsOfNamespace()) {
                if (otherPropNames.contains(pname) || ObjectType.isPropertySubtype(this.getLeftmostProp(qname = new QualifiedName(pname)), other.getLeftmostProp(qname), subSuperMap)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPropertySubtype(Property prop1, Property prop2, SubtypeCache subSuperMap) {
        return !(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap));
    }

    boolean isLooseSubtypeOf(ObjectType other, SubtypeCache subSuperMap) {
        Preconditions.checkState((this.isLoose || other.isLoose ? 1 : 0) != 0);
        if (other == TOP_OBJECT) {
            return true;
        }
        if (!this.isLoose) {
            for (String pname : other.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (!(this.isStruct() ? !this.mayHaveProp(qname) || !this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap) : this.mayHaveProp(qname) && !this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap))) continue;
                return false;
            }
        } else {
            for (String pname : this.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (!other.mayHaveProp(qname) || this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap)) continue;
                return false;
            }
        }
        if (other.fn == null) {
            return this.fn == null || other.isLoose();
        }
        if (this.fn == null) {
            return this.isLoose;
        }
        return this.fn.isLooseSubtypeOf(other.fn, subSuperMap);
    }

    ObjectType specialize(ObjectType other) {
        FunctionType newFn;
        PersistentMap<String, Property> newProps;
        Preconditions.checkState((boolean)ObjectType.areRelatedNominalTypes(this.nominalType, other.nominalType));
        if (this == TOP_OBJECT && other.objectKind.isUnrestricted()) {
            return other;
        }
        NominalType resultNomType = NominalType.pickSubclass(this.nominalType, other.nominalType);
        if (resultNomType != null && resultNomType.isClassy()) {
            Preconditions.checkState((this.fn == null && other.fn == null ? 1 : 0) != 0);
            PersistentMap<String, Property> newProps2 = ObjectType.meetPropsHelper(true, resultNomType, this.ns, this.props, other.props);
            if (newProps2 == BOTTOM_MAP) {
                return BOTTOM_OBJECT;
            }
            return new ObjectType(resultNomType, newProps2, null, this.ns, false, this.objectKind);
        }
        FunctionType thisFn = this.fn;
        boolean isLoose = this.isLoose;
        if (resultNomType != null && resultNomType.isFunction() && this.fn == null) {
            thisFn = other.fn;
            isLoose = other.fn.isLoose();
        }
        if ((newProps = ObjectType.meetPropsHelper(true, resultNomType, this.ns, this.props, other.props)) == BOTTOM_MAP) {
            return BOTTOM_OBJECT;
        }
        FunctionType functionType = newFn = thisFn == null ? null : thisFn.specialize(other.fn);
        if (!FunctionType.isInhabitable(newFn)) {
            return BOTTOM_OBJECT;
        }
        return new ObjectType(resultNomType, newProps, newFn, this.ns, isLoose, this.objectKind);
    }

    static ObjectType meet(ObjectType obj1, ObjectType obj2) {
        PersistentMap<String, Property> props;
        boolean isLoose;
        Preconditions.checkState((boolean)ObjectType.areRelatedNominalTypes(obj1.nominalType, obj2.nominalType));
        if (obj1 == TOP_OBJECT) {
            return obj2;
        }
        if (obj2 == TOP_OBJECT) {
            return obj1;
        }
        NominalType resultNomType = NominalType.pickSubclass(obj1.nominalType, obj2.nominalType);
        Namespace resultNs = Objects.equals(obj1.ns, obj2.ns) ? obj1.ns : null;
        FunctionType fn = FunctionType.meet(obj1.fn, obj2.fn);
        if (!FunctionType.isInhabitable(fn)) {
            return BOTTOM_OBJECT;
        }
        boolean bl = isLoose = obj1.isLoose && obj2.isLoose || fn != null && fn.isLoose();
        if (resultNomType != null && resultNomType.isFunction() && fn == null) {
            fn = obj1.fn == null ? obj2.fn : obj1.fn;
            isLoose = fn.isLoose();
        }
        if ((props = isLoose ? ObjectType.joinPropsLoosely(obj1.props, obj2.props) : ObjectType.meetPropsHelper(false, resultNomType, resultNs, obj1.props, obj2.props)) == BOTTOM_MAP) {
            return BOTTOM_OBJECT;
        }
        ObjectKind ok = ObjectKind.meet(obj1.objectKind, obj2.objectKind);
        return new ObjectType(resultNomType, props, fn, resultNs, isLoose, ok);
    }

    private static ObjectType join(ObjectType obj1, ObjectType obj2) {
        PersistentMap<String, Property> props;
        if (obj1 == TOP_OBJECT || obj2 == TOP_OBJECT) {
            return TOP_OBJECT;
        }
        NominalType nom1 = obj1.nominalType;
        NominalType nom2 = obj2.nominalType;
        Preconditions.checkState((boolean)ObjectType.areRelatedNominalTypes(nom1, nom2));
        if (obj1.equals(obj2)) {
            return obj1;
        }
        boolean isLoose = obj1.isLoose || obj2.isLoose;
        FunctionType fn = FunctionType.join(obj1.fn, obj2.fn);
        if (isLoose) {
            fn = fn == null ? null : fn.withLoose();
            props = ObjectType.joinPropsLoosely(obj1.props, obj2.props);
        } else {
            props = ObjectType.joinProps(obj1.props, obj2.props, nom1, nom2);
        }
        NominalType nominal = NominalType.pickSuperclass(nom1, nom2);
        if (nominal == null || !nominal.isFunction()) {
            fn = null;
        }
        Namespace ns = Objects.equals(obj1.ns, obj2.ns) ? obj1.ns : null;
        return ObjectType.makeObjectType(nominal, props, fn, ns, isLoose, ObjectKind.join(obj1.objectKind, obj2.objectKind));
    }

    static ImmutableSet<ObjectType> joinSets(ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2) {
        if (objs1.isEmpty()) {
            return objs2;
        }
        if (objs2.isEmpty()) {
            return objs1;
        }
        ObjectType[] objs1Arr = (ObjectType[])objs1.toArray((Object[])new ObjectType[0]);
        ObjectType[] keptFrom1 = Arrays.copyOf(objs1Arr, objs1Arr.length);
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj2 : objs2) {
            boolean addedObj2 = false;
            for (int i = 0; i < objs1Arr.length; ++i) {
                ObjectType obj1 = objs1Arr[i];
                NominalType nominalType1 = obj1.nominalType;
                NominalType nominalType2 = obj2.nominalType;
                if (!ObjectType.areRelatedNominalTypes(nominalType1, nominalType2)) continue;
                if (nominalType2 == null && nominalType1 != null && !obj1.isSubtypeOf(obj2, SubtypeCache.create()) || nominalType1 == null && nominalType2 != null && !obj2.isSubtypeOf(obj1, SubtypeCache.create())) break;
                keptFrom1[i] = null;
                addedObj2 = true;
                newObjs.add((Object)ObjectType.join(obj1, obj2));
                break;
            }
            if (addedObj2) continue;
            newObjs.add((Object)obj2);
        }
        for (ObjectType o : keptFrom1) {
            if (o == null) continue;
            newObjs.add((Object)o);
        }
        return newObjs.build();
    }

    private static boolean areRelatedNominalTypes(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return true;
        }
        return c1.isNominalSubtypeOf(c2) || c2.isNominalSubtypeOf(c1);
    }

    static ImmutableSet<ObjectType> meetSetsHelper(boolean specializeObjs1, Set<ObjectType> objs1, Set<ObjectType> objs2) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj2 : objs2) {
            for (ObjectType obj1 : objs1) {
                ObjectType newObj;
                if (!ObjectType.areRelatedNominalTypes(obj1.nominalType, obj2.nominalType)) continue;
                if (specializeObjs1) {
                    newObj = obj1.specialize(obj2);
                    if (newObj == null) {
                        continue;
                    }
                } else {
                    newObj = ObjectType.meet(obj1, obj2);
                }
                newObjs.add((Object)newObj);
            }
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> meetSets(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(false, objs1, objs2);
    }

    static ImmutableSet<ObjectType> specializeSet(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(true, objs1, objs2);
    }

    FunctionType getFunType() {
        return this.fn;
    }

    NominalType getNominalType() {
        return this.nominalType == null ? builtinObject : this.nominalType;
    }

    @Override
    public JSType getProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (qname.isIdentifier()) {
            return p == null ? JSType.UNDEFINED : p.getType();
        }
        Preconditions.checkState((p != null ? 1 : 0) != 0);
        return p.getType().getProp(qname.getAllButLeftmost());
    }

    @Override
    public JSType getDeclaredProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (p == null) {
            return null;
        }
        if (qname.isIdentifier()) {
            return p.isDeclared() ? p.getDeclaredType() : null;
        }
        return p.getType().getDeclaredProp(qname.getAllButLeftmost());
    }

    private static Property getPropHelper(String pname, Namespace ns, NominalType nt) {
        Property p;
        if (ns != null && (p = ns.getNsProp(pname)) != null) {
            return p;
        }
        return nt == null ? null : nt.getProp(pname);
    }

    private Property getLeftmostProp(QualifiedName qname) {
        String objName = qname.getLeftmostName();
        Property p = (Property)this.props.get(objName);
        if (p != null) {
            return p;
        }
        p = ObjectType.getPropHelper(objName, this.ns, this.nominalType);
        if (p != null) {
            return p;
        }
        return builtinObject == null ? null : builtinObject.getProp(objName);
    }

    @Override
    public boolean mayHaveProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        return p != null && (qname.isIdentifier() || p.getType().mayHaveProp(qname.getAllButLeftmost()));
    }

    @Override
    public boolean hasProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null;
    }

    @Override
    public boolean hasConstantProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null && p.isConstant();
    }

    static ObjectType unifyUnknowns(ObjectType t1, ObjectType t2) {
        NominalType nt;
        if (t1.isLoose()) {
            return t1.equals(t2) ? t1 : null;
        }
        if (t2.isLoose()) {
            return null;
        }
        if (!Objects.equals(t1.ns, t2.ns)) {
            return null;
        }
        NominalType nt1 = t1.nominalType;
        NominalType nt2 = t2.nominalType;
        if (nt1 == null && nt2 == null) {
            nt = null;
        } else {
            if (nt1 == null || nt2 == null) {
                return null;
            }
            nt = NominalType.unifyUnknowns(nt1, nt2);
            if (nt == null) {
                return null;
            }
        }
        FunctionType newFn = null;
        if ((t1.fn != null || t2.fn != null) && (newFn = FunctionType.unifyUnknowns(t1.fn, t2.fn)) == null) {
            return null;
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String propName : t1.props.keySet()) {
            Property prop1 = (Property)t1.props.get(propName);
            Property prop2 = (Property)t2.props.get(propName);
            if (prop2 == null) {
                return null;
            }
            Property p = Property.unifyUnknowns(prop1, prop2);
            if (p == null) {
                return null;
            }
            newProps = newProps.with(propName, p);
        }
        return ObjectType.makeObjectType(nt, newProps, newFn, t1.ns, false, ObjectKind.join(t1.objectKind, t2.objectKind));
    }

    boolean unifyWithSubtype(ObjectType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        if (!(this.fn == null || other.fn != null && this.fn.unifyWithSubtype(other.fn, typeParameters, typeMultimap, subSuperMap))) {
            return false;
        }
        NominalType thisNt = this.nominalType;
        NominalType otherNt = other.nominalType;
        if (thisNt != null && otherNt != null) {
            if (thisNt.unifyWithSubtype(otherNt, typeParameters, typeMultimap, subSuperMap)) {
                return true;
            }
            if (thisNt.isClass()) {
                return false;
            }
            if (thisNt.isStructuralInterface()) {
                if (thisNt.equals(subSuperMap.get(otherNt))) {
                    return true;
                }
                subSuperMap = subSuperMap.with(otherNt, thisNt);
            }
        }
        if (thisNt != null && !thisNt.isStructuralInterface() && otherNt == null) {
            return false;
        }
        Set<String> thisProps = thisNt != null && thisNt.isStructuralInterface() ? thisNt.getAllPropsOfInterface() : this.props.keySet();
        return this.unifyPropsWithSubtype(other, thisProps, typeParameters, typeMultimap, subSuperMap);
    }

    private boolean unifyPropsWithSubtype(ObjectType other, Set<String> thisProps, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        for (String pname : thisProps) {
            QualifiedName qname = new QualifiedName(pname);
            Property thisProp = this.getLeftmostProp(qname);
            Property otherProp = other.getLeftmostProp(qname);
            if (!(thisProp.isOptional() ? otherProp != null && !thisProp.getType().unifyWithSubtype(otherProp.getType(), typeParameters, typeMultimap, subSuperMap) : otherProp == null || otherProp.isOptional() || !thisProp.getType().unifyWithSubtype(otherProp.getType(), typeParameters, typeMultimap, subSuperMap))) continue;
            return false;
        }
        return true;
    }

    ObjectType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (concreteTypes.isEmpty()) {
            return this;
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry propsEntry : this.props.entrySet()) {
            String pname = (String)propsEntry.getKey();
            Property newProp = ((Property)propsEntry.getValue()).substituteGenerics(concreteTypes);
            newProps = newProps.with(pname, newProp);
        }
        FunctionType newFn = this.fn == null ? null : this.fn.substituteGenerics(concreteTypes);
        return ObjectType.makeObjectType(this.nominalType == null ? null : this.nominalType.instantiateGenerics(concreteTypes), newProps, newFn, this.ns, newFn != null && newFn.isQmarkFunction() || this.isLoose, this.objectKind);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        if (!this.hasNonPrototypeProperties()) {
            if (this.fn != null) {
                return this.fn.appendTo(builder);
            }
            if (this.getNominalType() != null) {
                return this.getNominalType().appendTo(builder);
            }
        }
        if (this.nominalType != null && !this.nominalType.getName().equals("Function")) {
            this.nominalType.appendTo(builder);
        } else if (this.isStruct()) {
            builder.append("struct");
        } else if (this.isDict()) {
            builder.append("dict");
        } else if (this.ns != null) {
            builder.append(this.ns.toString());
        }
        if (this.fn != null) {
            builder.append("<|");
            this.fn.appendTo(builder);
            builder.append("|>");
        }
        if (this.nominalType == null || !this.props.isEmpty()) {
            builder.append('{');
            boolean firstIteration = true;
            for (String pname : new TreeSet(this.props.keySet())) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    builder.append(", ");
                }
                builder.append(pname);
                builder.append(':');
                ((Property)this.props.get(pname)).appendTo(builder);
            }
            builder.append('}');
        }
        if (this.isLoose) {
            builder.append(" (loose)");
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof ObjectType));
        ObjectType other = (ObjectType)o;
        return Objects.equals(this.fn, other.fn) && Objects.equals(this.ns, other.ns) && Objects.equals(this.nominalType, other.nominalType) && Objects.equals(this.props, other.props);
    }

    public int hashCode() {
        return Objects.hash(this.fn, this.ns, this.props, this.nominalType);
    }
}

