/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.generic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAddProperties;
import org.eclipse.wb.internal.core.model.property.ITypedProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringListPropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

abstract class ModelMethodPropertyAbstractSupport {
    protected final ObjectInfo object;
    private final String prefix;

    public ModelMethodPropertyAbstractSupport(ObjectInfo object, String prefix) {
        this.object = object;
        this.prefix = prefix;
    }

    protected final void install() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ModelMethodPropertyAbstractSupport.this.installEx();
            }
        });
    }

    private void installEx() throws Exception {
        Map parameters = GlobalState.getParametersProvider().getParameters((Object)this.object);
        for (String parameter : parameters.keySet()) {
            if (!parameter.startsWith(this.prefix)) continue;
            this.createParameterProcessor().process(parameter);
        }
    }

    protected abstract ParameterProcessor createParameterProcessor();

    protected abstract class ParameterProcessor {
        protected String getterSignature;
        protected String setterSignature;
        protected Class<?> type;
        protected PropertyEditor propertyEditor;
        protected String title;
        protected PropertyCategory category = PropertyCategory.NORMAL;
        protected Method getter;
        protected Method setter;

        protected ParameterProcessor() {
        }

        public void process(String parameter) throws Exception {
            String[] stringArray = StringUtils.split((String)parameter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.processParameterPart(part);
                ++n2;
            }
            Object message = this.validate();
            if (message != null) {
                message = (String)message + "\n" + parameter;
                EditorWarning warning = new EditorWarning((String)message, null);
                GlobalState.getOtherHelper().addWarning(warning);
                return;
            }
            this.configureProperty();
        }

        protected abstract void configureProperty();

        protected void processParameterPart(String part) throws Exception {
            if (part.startsWith("getter=")) {
                this.getterSignature = StringUtils.removeStart((String)part, (String)"getter=");
            }
            if (part.startsWith("setter=")) {
                this.setterSignature = StringUtils.removeStart((String)part, (String)"setter=");
            }
            if (part.startsWith("type=")) {
                String typeName = StringUtils.removeStart((String)part, (String)"type=");
                this.type = ReflectionUtils.getClassByName((ClassLoader)GlobalState.getClassLoader(), (String)typeName);
                if (this.propertyEditor == null) {
                    this.propertyEditor = GlobalState.getDescriptionHelper().getEditorForType(this.type);
                }
            }
            if (part.startsWith("editor=")) {
                String desc = StringUtils.removeStart((String)part, (String)"editor=");
                this.parseEditor(desc);
            }
            if (part.startsWith("title=")) {
                this.title = StringUtils.removeStart((String)part, (String)"title=");
            }
            if (part.startsWith("category=")) {
                String categoryText = StringUtils.removeStart((String)part, (String)"category=");
                this.category = PropertyCategory.get((String)categoryText, (PropertyCategory)this.category);
            }
        }

        private void parseEditor(String desc) {
            if (desc.startsWith("strings(")) {
                desc = StringUtils.substringBetween((String)desc, (String)"strings(", (String)")");
                String[] strings = StringUtils.split((String)desc, (char)',');
                StringListPropertyEditor stringsPropertyEditor = new StringListPropertyEditor();
                stringsPropertyEditor.configure(strings);
                this.propertyEditor = stringsPropertyEditor;
            }
        }

        protected String validate() throws Exception {
            if (this.getterSignature == null || this.setterSignature == null || this.propertyEditor == null || this.title == null) {
                return "No 'getter' or 'setter' or 'type' or 'editor' or 'title' attributes: ";
            }
            this.processGetterSignature();
            this.getter = ReflectionUtils.getMethodBySignature(ModelMethodPropertyAbstractSupport.this.object.getClass(), (String)this.getterSignature);
            if (this.getter == null) {
                return "Invalid '" + ModelMethodPropertyAbstractSupport.this.prefix + "' getter: " + this.getterSignature;
            }
            this.processSetterSignature();
            this.setter = ReflectionUtils.getMethodBySignature(ModelMethodPropertyAbstractSupport.this.object.getClass(), (String)this.setterSignature);
            if (this.setter == null) {
                return "Invalid '" + ModelMethodPropertyAbstractSupport.this.prefix + "' setter: " + this.setterSignature;
            }
            return null;
        }

        protected abstract void processGetterSignature();

        protected abstract void processSetterSignature();

        protected abstract class PropertyProcessor {
            private final Map<ObjectInfo, Property> m_properties = new WeakHashMap<ObjectInfo, Property>();

            protected PropertyProcessor() {
                ((ParameterProcessor)ParameterProcessor.this).ModelMethodPropertyAbstractSupport.this.object.addBroadcastListener((Object)new ObjectInfoAddProperties(){

                    public void invoke(ObjectInfo target, List<Property> properties) throws Exception {
                        if (PropertyProcessor.this.isPropertyTarget(target)) {
                            Property property = PropertyProcessor.this.createProperty(target);
                            properties.add(property);
                        }
                    }
                });
            }

            private Property createProperty(ObjectInfo target) throws Exception {
                Property property = this.m_properties.get(target);
                if (property == null) {
                    property = new ModelProperty(target);
                    property.setCategory(ParameterProcessor.this.category);
                    this.m_properties.put(target, property);
                }
                return property;
            }

            protected abstract boolean isPropertyTarget(ObjectInfo var1);

            protected abstract Object getValue(ObjectInfo var1) throws Exception;

            protected abstract void setValue(ObjectInfo var1, Object var2) throws Exception;

            private class ModelProperty
            extends Property
            implements ITypedProperty {
                private final ObjectInfo target;

                public ModelProperty(ObjectInfo target) {
                    super(((PropertyProcessor)PropertyProcessor.this).ParameterProcessor.this.propertyEditor);
                    this.target = target;
                }

                public Class<?> getType() {
                    return ((PropertyProcessor)PropertyProcessor.this).ParameterProcessor.this.type;
                }

                public String getTitle() {
                    return ((PropertyProcessor)PropertyProcessor.this).ParameterProcessor.this.title;
                }

                public boolean isModified() throws Exception {
                    return this.getValue() != UNKNOWN_VALUE;
                }

                public Object getValue() throws Exception {
                    return PropertyProcessor.this.getValue(this.target);
                }

                public void setValue(Object value) throws Exception {
                    PropertyProcessor.this.setValue(this.target, value);
                }
            }
        }
    }
}

