/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.ui.DebuggerCoreUIPlugin;
import org.eclipse.datatools.sqltools.debugger.debug.BreakpointLocationHandler;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && DebuggerCoreUIPlugin.getActiveWorkbenchShell() != null) {
            DebuggerCoreUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            IEditorPart editorPart = (IEditorPart)part;
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            this.toggleLineBreakpoints(editorPart, lineNumber);
        }
    }

    public void toggleLineBreakpoints(IEditorPart editorPart, int lineNumber) throws CoreException {
        this.report(null, (IWorkbenchPart)editorPart);
        IEditorInput editorInput = editorPart.getEditorInput();
        if (editorInput instanceof ProcEditorInput) {
            ProcIdentifier procid = ((ProcEditorInput)editorInput).getProcIdentifier();
            SPLineBreakpoint breakpoint = SPDebugModelUtil.findLineBreakpoint((ProcIdentifier)procid, (int)lineNumber);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                breakpoint = SPDebugModelUtil.createLineBreakpoint((ProcIdentifier)procid, (int)lineNumber, (boolean)true);
                BreakpointLocationHandler.handleNewBreakpoint(breakpoint, procid, lineNumber, editorPart);
            }
        } else {
            return;
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        if (!(part instanceof IEditorPart)) {
            return false;
        }
        IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
        return editorInput instanceof ProcEditorInput;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

