/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfig;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfigBuilder;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class Federate
extends ConsoleCommand {
    @Override
    public String getName() {
        return "federate";
    }

    @Override
    public String getHelpShort() {
        return "Federate existing repositories";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nfederate  <fedID> <repoID_1> <repoID_2> [<repoID_n>]*\n  <fedId>                  The id to assign the federated repository.\n  <repoID1> <repoID2>      The id's of at least 2 repositories to federate.\n  [<repoID_n>]*            The id's of 0 or mare additional repositories to federate.\n\nYou will be prompted to enter a description for the federated repository as well.";
    }

    public Federate(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... parameters) {
        if (parameters.length < 4) {
            this.writeln(this.getHelpLong());
        } else {
            LinkedList<String> plist = new LinkedList<String>(Arrays.asList(parameters));
            plist.remove();
            if (this.distinctValues(plist)) {
                String fedID = plist.pop();
                this.federate(fedID, plist);
            } else {
                this.writeError("Duplicate repository id's specified.");
            }
        }
    }

    private boolean distinctValues(Deque<String> plist) {
        return plist.size() == new HashSet<String>(plist).size();
    }

    private void federate(String fedID, Deque<String> memberIDs) {
        if (this.LOGGER.isDebugEnabled()) {
            this.logCallDetails(fedID, memberIDs);
        }
        RepositoryManager manager = this.state.getManager();
        try {
            if (manager.hasRepositoryConfig(fedID)) {
                this.writeError(fedID + " already exists.");
            } else if (this.validateMembers(manager, memberIDs)) {
                String description = this.consoleIO.readln("Federation Description (optional): ");
                FedXRepositoryConfig federationConfig = FedXRepositoryConfigBuilder.create().withResolvableEndpoint(memberIDs).build();
                RepositoryConfig config = new RepositoryConfig(fedID, (RepositoryImplConfig)federationConfig);
                config.setTitle(description);
                manager.addRepositoryConfig(config);
                this.writeln("Federation created.");
            }
        }
        catch (RepositoryException | RepositoryConfigException rce) {
            this.writeError("Federation failed", (Exception)rce);
        }
        catch (RDF4JException rce) {
            this.writeError("I/O exception on federation", (Exception)((Object)rce));
        }
    }

    private boolean validateMembers(RepositoryManager manager, Deque<String> memberIDs) {
        boolean result = true;
        try {
            for (String memberID : memberIDs) {
                if (manager.hasRepositoryConfig(memberID)) continue;
                result = false;
                this.writeError(memberID + " does not exist.");
            }
        }
        catch (RepositoryException | RepositoryConfigException re) {
            this.writeError(re.getMessage());
        }
        return result;
    }

    private void logCallDetails(String fedID, Deque<String> memberIDs) {
        StringBuilder builder = new StringBuilder();
        builder.append("Federate called with federation ID = " + fedID + ", and member ID's = ");
        for (String member : memberIDs) {
            builder.append("[").append(member).append("]");
        }
        this.LOGGER.debug(builder.toString());
    }

    private String getOptionalParamValue(Deque<String> parameters, String name, String defaultValue) {
        String result = defaultValue;
        for (String parameter : parameters) {
            String[] parsed;
            if (parameter.length() < name.length() || !parameter.substring(0, name.length()).equalsIgnoreCase(name) || (parsed = parameter.split("=")).length != 2 || !parsed[0].equalsIgnoreCase(name)) continue;
            result = parsed[1].toLowerCase();
            parameters.remove(parameter);
            break;
        }
        return result;
    }
}

