/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLQueries;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTString;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

@InternalUseOnly
public class StringEscapesProcessor {
    public static void process(ASTOperationContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e);
        }
    }

    private static class StringProcessor
    extends AbstractASTVisitor {
        @Override
        public Object visit(ASTString stringNode, Object data) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SPARQLQueries.unescape(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(stringNode, data);
        }
    }
}

