/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntSingletonMap;

public enum ImmutableObjectIntMapFactoryImpl implements ImmutableObjectIntMapFactory
{
    INSTANCE;


    public <K> ImmutableObjectIntMap<K> empty() {
        return ImmutableObjectIntEmptyMap.INSTANCE;
    }

    public <K> ImmutableObjectIntMap<K> of() {
        return this.empty();
    }

    public <K> ImmutableObjectIntMap<K> with() {
        return this.empty();
    }

    public <K> ImmutableObjectIntMap<K> of(K key, int value) {
        return this.with(key, value);
    }

    public <K> ImmutableObjectIntMap<K> with(K key, int value) {
        return new ImmutableObjectIntSingletonMap<K>(key, value);
    }

    public <K> ImmutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K> map) {
        return this.withAll(map);
    }

    public <K> ImmutableObjectIntMap<K> withAll(ObjectIntMap<? extends K> map) {
        if (map instanceof ImmutableObjectIntMap) {
            return (ImmutableObjectIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            Object[] array = new Object[1];
            map.forEachKey((Procedure & Serializable)each -> {
                array[0] = each;
            });
            return new ImmutableObjectIntSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableObjectIntHashMap<K>(map);
    }

    public <T, K> ImmutableObjectIntMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, IntFunction<? super T> valueFunction) {
        MutableObjectIntMap map = ObjectIntMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

