/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.rdf.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.RdfGraph;
import no.hasmac.rdf.RdfNQuad;
import no.hasmac.rdf.RdfResource;
import no.hasmac.rdf.RdfTriple;
import no.hasmac.rdf.impl.RdfGraphImpl;
import no.hasmac.rdf.impl.RdfNQuadImpl;

final class RdfDatasetImpl
implements RdfDataset {
    private final Map<RdfResource, RdfGraphImpl> graphs = new HashMap<RdfResource, RdfGraphImpl>(1);
    private final List<RdfNQuad> nquads = new ArrayList<RdfNQuad>();
    private final RdfGraphImpl defaultGraph = new RdfGraphImpl();

    protected RdfDatasetImpl() {
    }

    @Override
    public RdfGraph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public List<RdfNQuad> toList() {
        return this.nquads;
    }

    @Override
    public RdfDataset add(RdfNQuad nquad) {
        if (nquad == null) {
            throw new IllegalArgumentException();
        }
        Optional<RdfResource> graphName = nquad.getGraphName();
        if (graphName.isPresent()) {
            RdfGraphImpl graph = this.graphs.get(graphName.get());
            if (graph == null) {
                graph = new RdfGraphImpl();
                this.graphs.put(graphName.get(), graph);
                graph.add(nquad);
                this.nquads.add(nquad);
            } else if (!graph.contains(nquad)) {
                graph.add(nquad);
                this.nquads.add(nquad);
            }
        } else if (!this.defaultGraph.contains(nquad)) {
            this.defaultGraph.add(nquad);
            this.nquads.add(nquad);
        }
        return this;
    }

    @Override
    public Set<RdfResource> getGraphNames() {
        return this.graphs.keySet();
    }

    @Override
    public Optional<RdfGraph> getGraph(RdfResource graphName) {
        return Optional.ofNullable((RdfGraph)this.graphs.get(graphName));
    }

    @Override
    public int size() {
        return this.nquads.size();
    }

    @Override
    public RdfDataset add(RdfTriple triple) {
        RdfNQuadImpl nquad = new RdfNQuadImpl(triple.getSubject(), triple.getPredicate(), triple.getObject(), null);
        if (!this.defaultGraph.contains(nquad)) {
            this.defaultGraph.add(nquad);
            this.nquads.add(nquad);
        }
        return this;
    }
}

