/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Timezone
implements Function {
    @Override
    public String getURI() {
        return FN.TIMEZONE_FROM_DATETIME.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("TIMEZONE requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isCalendarDatatype()) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int timezoneOffset = calValue.getTimezone();
                    if (Integer.MIN_VALUE != timezoneOffset) {
                        int minutes = Math.abs(timezoneOffset);
                        int hours = minutes / 60;
                        minutes -= hours * 60;
                        StringBuilder tzDuration = new StringBuilder();
                        if (timezoneOffset < 0) {
                            tzDuration.append("-");
                        }
                        tzDuration.append("PT");
                        if (hours > 0) {
                            tzDuration.append(hours + "H");
                        }
                        if (minutes > 0) {
                            tzDuration.append(minutes + "M");
                        }
                        if (timezoneOffset == 0) {
                            tzDuration.append("0S");
                        }
                        return valueFactory.createLiteral(tzDuration.toString(), CoreDatatype.XSD.DAYTIMEDURATION);
                    }
                    throw new ValueExprEvaluationException("can not determine timezone from value: " + argValue);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

