/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.impl;

import com.google.common.base.Function;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonBoundingBox;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.SimpleWKTShapeParser;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.impl.LuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDocument
implements SearchDocument {
    private final Document doc;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String POINT_FIELD_PREFIX = "_pt_";
    private static final String GEO_FIELD_PREFIX = "_geo_";
    private final Function<? super String, ? extends SpatialStrategy> geoStrategyMapper;

    public LuceneDocument(Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this(new Document(), geoStrategyMapper);
    }

    public LuceneDocument(Document doc, Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this.doc = doc;
        this.geoStrategyMapper = geoStrategyMapper;
    }

    public LuceneDocument(String id, String resourceId, String context, Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this(geoStrategyMapper);
        this.setId(id);
        this.setResource(resourceId);
        this.setContext(context);
    }

    private void setId(String id) {
        LuceneIndex.addIDField(id, this.doc);
    }

    private void setContext(String context) {
        LuceneIndex.addContextField(context, this.doc);
    }

    private void setResource(String resourceId) {
        LuceneIndex.addResourceField(resourceId, this.doc);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getId() {
        return this.doc.get("id");
    }

    public String getResource() {
        return this.doc.get("uri");
    }

    public String getContext() {
        return this.doc.get("context");
    }

    public Set<String> getPropertyNames() {
        List fields = this.doc.getFields();
        HashSet<String> names = new HashSet<String>();
        for (IndexableField field : fields) {
            String name = field.name();
            if (!SearchFields.isPropertyField((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public void addProperty(String name) {
    }

    public void addProperty(String name, String text) {
        LuceneIndex.addPredicateField(name, text, this.doc);
        LuceneIndex.addTextField(text, this.doc);
    }

    public boolean hasProperty(String fieldName, String value) {
        String[] fields = this.doc.getValues(fieldName);
        if (fields != null) {
            for (String field : fields) {
                if (!value.equals(field)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProperty(String name) {
        return Arrays.asList(this.doc.getValues(name));
    }

    private void indexShape(Object shape, String field) {
        if (shape instanceof Object[]) {
            Object[] geometries = (Object[])shape;
            for (int i = 0; i < geometries.length; ++i) {
                this.indexShape(geometries[i], field);
            }
        } else if (shape instanceof Polygon) {
            for (Field f : LatLonShape.createIndexableFields((String)(GEO_FIELD_PREFIX + field), (Polygon)((Polygon)shape))) {
                this.doc.add((IndexableField)f);
            }
        } else if (shape instanceof Line) {
            for (Field f : LatLonShape.createIndexableFields((String)(GEO_FIELD_PREFIX + field), (Line)((Line)shape))) {
                this.doc.add((IndexableField)f);
            }
        } else if (shape instanceof double[]) {
            double[] point = (double[])shape;
            for (Field f : LatLonShape.createIndexableFields((String)(GEO_FIELD_PREFIX + field), (double)point[1], (double)point[0])) {
                this.doc.add((IndexableField)f);
            }
            this.doc.add((IndexableField)new LatLonPoint(POINT_FIELD_PREFIX + field, point[1], point[0]));
        } else if (shape instanceof Rectangle) {
            Rectangle box = (Rectangle)shape;
            this.doc.add((IndexableField)new LatLonBoundingBox(GEO_FIELD_PREFIX + field, box.minLat, box.minLon, box.maxLat, box.maxLon));
        } else {
            throw new IllegalArgumentException("Geometry for shape " + shape.toString() + " is not supported");
        }
    }

    public void addGeoProperty(String field, String value) {
        LuceneIndex.addStoredOnlyPredicateField(field, value, this.doc);
        try {
            String wkt = value;
            Object shape = SimpleWKTShapeParser.parse((String)wkt);
            this.indexShape(shape, field);
        }
        catch (ParseException e) {
            this.logger.warn("error while processing geo property", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("error while parsing wkt geometry", (Throwable)e);
        }
    }
}

