/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;

public class TapIntIterable
extends AbstractLazyIntIterable {
    private final IntIterable adapted;
    private final IntProcedure procedure;

    public TapIntIterable(IntIterable delegate, IntProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    public void each(IntProcedure procedure) {
        this.adapted.forEach((IntProcedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.adapted.anySatisfy((IntPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.adapted.allSatisfy((IntPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.adapted.noneSatisfy((IntPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.adapted.detectIfNone((IntPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    public IntIterator intIterator() {
        return new TapIntIterator(this.adapted, this.procedure);
    }

    public static class TapIntIterator
    implements IntIterator {
        private final IntIterator iterator;
        private final IntProcedure procedure;

        public TapIntIterator(IntIterable iterable, IntProcedure procedure) {
            this(iterable.intIterator(), procedure);
        }

        public TapIntIterator(IntIterator iterator, IntProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int next() {
            int next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

