/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.n3;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;

public class N3Writer
implements RDFWriter,
CharSink {
    private final TurtleWriter ttlWriter;
    private WriterConfig writerConfig = new WriterConfig();

    public N3Writer(OutputStream out) {
        this(out, null);
    }

    public N3Writer(OutputStream out, ParsedIRI baseIRI) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8), baseIRI);
    }

    public N3Writer(Writer writer) {
        this(writer, null);
    }

    public N3Writer(Writer writer, ParsedIRI baseIRI) {
        this.ttlWriter = new TurtleWriter(writer, baseIRI);
    }

    public Writer getWriter() {
        return this.ttlWriter.getWriter();
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.N3;
    }

    public RDFWriter setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
        return this;
    }

    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        this.getWriterConfig().set(setting, value);
        return this;
    }

    public void startRDF() throws RDFHandlerException {
        this.ttlWriter.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.ttlWriter.endRDF();
    }

    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        this.ttlWriter.handleNamespace(prefix, name);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.ttlWriter.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.ttlWriter.handleComment(comment);
    }

    public FileFormat getFileFormat() {
        return this.getRDFFormat();
    }
}

