/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jface.text.BadLocationException;

public class CleanUpNLSUtils {
    public static NLSLine scanCurrentLine(ICompilationUnit cu, ASTNode exp) {
        CompilationUnit cUnit = (CompilationUnit)exp.getRoot();
        int startLine = cUnit.getLineNumber(exp.getStartPosition());
        int lineStart = cUnit.getPosition(startLine, 0);
        int endOfLine = cUnit.getPosition(startLine + 1, 0);
        try {
            NLSLine[] lines = NLSScanner.scan(cu.getBuffer().getText(lineStart, endOfLine - lineStart));
            if (lines.length > 0) {
                return lines[0];
            }
        }
        catch (IndexOutOfBoundsException | JavaModelException | InvalidInputException | BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }
}

