/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;

public class VarConflictVisitor
extends InterruptibleVisitor {
    private final Set<String> localVariableIds;
    private boolean varConflicting;
    private ASTNode startNode;
    private final boolean includeInnerScopes;

    public VarConflictVisitor(Set<SimpleName> localVariables, boolean includeInnerScopes) {
        this.includeInnerScopes = includeInnerScopes;
        this.localVariableIds = new HashSet<String>(localVariables.size());
        for (SimpleName localVariable : localVariables) {
            this.localVariableIds.add(localVariable.getIdentifier());
        }
    }

    public boolean isVarConflicting() {
        return this.varConflicting;
    }

    @Override
    public void traverseNodeInterruptibly(ASTNode aStartNode) {
        this.startNode = aStartNode;
        super.traverseNodeInterruptibly(this.startNode);
    }

    public boolean visit(SimpleName concurrentVariable) {
        if ((concurrentVariable.resolveBinding() == null || concurrentVariable.resolveBinding().getKind() == 3) && this.localVariableIds.contains(concurrentVariable.getIdentifier())) {
            this.varConflicting = true;
            return this.interruptVisit();
        }
        return true;
    }

    public boolean visit(Block node) {
        return this.startNode == node || this.includeInnerScopes;
    }
}

