/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import org.eclipse.emf.validation.ui.internal.ValidationUIPlugin;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.emf.validation.ui.internal.preferences.ValidationLiveProblemsDestination;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValidationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite outerComposite;
    private RadioGroupFieldEditor liveProblemDisplayField;
    private Composite innerComposite1;
    private Composite innerComposite2;
    private BooleanFieldEditor warningsInDialog;
    private BooleanFieldEditor showOutputView;

    public ValidationPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 1;
        panel.setLayout((Layout)panelLayout);
        GridData blockData = new GridData();
        blockData.grabExcessHorizontalSpace = true;
        blockData.horizontalAlignment = 4;
        blockData.horizontalSpan = 1;
        panel.setLayoutData((Object)blockData);
        this.createLiveValidationProblemsGroup(panel);
        this.applyDialogFont(panel);
    }

    protected void initialize() {
        super.initialize();
        this.setCheckboxesEnablement(ValidationUIPlugin.getPlugin().getPreferenceStore().getString("Validation.liveProblemsDisplay"));
    }

    private void createLiveValidationProblemsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ValidationUIMessages.Validation_liveValidationGroupLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        this.outerComposite = new Composite((Composite)group, 0);
        this.liveProblemDisplayField = new RadioGroupFieldEditor("Validation.liveProblemsDisplay", ValidationUIMessages.Validation_liveValidationDestinationPrompt, 1, new String[][]{{ValidationUIMessages.Validation_liveValidationDestination_dialogComboItem, ValidationLiveProblemsDestination.DIALOG.getName()}, {ValidationUIMessages.Validation_liveValidationDestination_consoleComboItem, ValidationLiveProblemsDestination.CONSOLE.getName()}}, this.outerComposite){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                super.fireValueChanged(property, oldValue, newValue);
                ValidationPreferencePage.this.setCheckboxesEnablement((String)newValue);
            }
        };
        this.addField((FieldEditor)this.liveProblemDisplayField);
        this.innerComposite1 = new Composite((Composite)group, 0);
        this.warningsInDialog = new BooleanFieldEditor("Validation.liveWarningsInDialog", ValidationUIMessages.Validation_liveValidationWarnDialogPrompt, this.innerComposite1){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                ValidationPreferencePage.this.setCheckboxesEnablement(null);
            }
        };
        this.addField((FieldEditor)this.warningsInDialog);
        this.innerComposite2 = new Composite((Composite)group, 0);
        this.showOutputView = new BooleanFieldEditor("Validation.liveShowConsole", ValidationUIMessages.Validation_liveValidationShowConsolePrompt, this.innerComposite2);
        this.addField((FieldEditor)this.showOutputView);
    }

    void setCheckboxesEnablement(String newSelection) {
        if (newSelection != null) {
            this.warningsInDialog.setEnabled(ValidationLiveProblemsDestination.DIALOG.getName().equals(newSelection), this.innerComposite1);
            this.showOutputView.setEnabled(ValidationLiveProblemsDestination.CONSOLE.getName().equals(newSelection) || !this.warningsInDialog.getBooleanValue(), this.innerComposite2);
        } else {
            this.showOutputView.setEnabled(!this.warningsInDialog.getBooleanValue(), this.innerComposite2);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ValidationUIPlugin.getPlugin().getPreferenceStore();
    }

    public boolean performOk() {
        super.performOk();
        ValidationUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

