/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaMode;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.network.DataSerializer;
import org.eclipse.rcptt.tesla.internal.core.network.DefaultConnectionMonitor;
import org.eclipse.rcptt.tesla.internal.core.network.IConnectionMonitor;

public abstract class TeslaNetworkCommunication
extends Thread {
    protected Socket communicationSocket;
    protected int port;
    protected String host;
    protected DataInputStream input;
    protected DataOutputStream output;
    protected IConnectionMonitor monitor;
    private boolean canceled;

    public TeslaNetworkCommunication(String host, int port) {
        this(host, port, new DefaultConnectionMonitor());
    }

    public TeslaNetworkCommunication(String host, int port, IConnectionMonitor monitor) {
        super("Tesla network communication to :" + host + ":" + String.valueOf((Object)port));
        this.host = host;
        this.port = port;
        this.monitor = monitor;
    }

    public void cancelConnection() {
        if (this.isConnected()) {
            this.canceled = true;
            this.close();
            this.interrupt();
        }
    }

    @Override
    public void run() {
        this.internalRun();
    }

    protected void internalRun() {
        try {
            this.exec();
        }
        catch (SocketException e) {
            if (e.getMessage() != null && !e.getMessage().equals("Socket closed")) {
                TeslaCore.log(e);
            }
        }
        catch (IOException e) {
            TeslaCore.log(e);
        }
    }

    public void exec() throws IOException {
        boolean needClose = true;
        try {
            try {
                if (this.doConnect(this.monitor)) {
                    needClose = this.performCommunications();
                }
            }
            catch (Throwable t) {
                if (t instanceof SocketException) {
                    if (!this.communicationSocket.isClosed()) {
                        TeslaCore.log(t);
                    }
                } else {
                    TeslaCore.log(t);
                }
                if (needClose) {
                    this.close();
                }
            }
        }
        finally {
            if (needClose) {
                this.close();
            }
        }
    }

    protected boolean doConnect(IConnectionMonitor monitor) throws IOException {
        long timeStart = System.currentTimeMillis();
        while (this.communicationSocket == null || !this.communicationSocket.isConnected()) {
            if (monitor.getTimeout() != 0L && System.currentTimeMillis() > timeStart + monitor.getTimeout()) break;
            if (this.canceled) {
                return false;
            }
            this.tryToConnet();
            if (monitor.getTimeout() == 0L) break;
            if (this.communicationSocket != null && this.communicationSocket.isConnected()) continue;
            try {
                Thread.sleep(monitor.getPause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.communicationSocket == null || !this.communicationSocket.isConnected()) {
            monitor.timeout();
            return false;
        }
        InputStream stream = this.communicationSocket.getInputStream();
        this.input = new DataInputStream(stream);
        this.output = new DataOutputStream(this.communicationSocket.getOutputStream());
        return true;
    }

    protected void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.communicationSocket != null) {
                this.communicationSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract boolean performCommunications() throws IOException;

    private void tryToConnet() {
        this.monitor.tryToConnect();
        try {
            try {
                this.communicationSocket = new Socket(this.host, this.port);
                this.communicationSocket.setKeepAlive(true);
            }
            catch (Exception e) {
                this.monitor.connectFailed(e);
                if (this.communicationSocket != null && this.communicationSocket.isConnected()) {
                    this.monitor.connected();
                }
            }
        }
        finally {
            if (this.communicationSocket != null && this.communicationSocket.isConnected()) {
                this.monitor.connected();
            }
        }
    }

    public boolean isConnected() {
        if (!this.isAlive()) {
            return false;
        }
        if (this.communicationSocket != null && this.communicationSocket.isConnected()) {
            return !this.communicationSocket.isClosed();
        }
        return false;
    }

    protected void setMode(TeslaMode mode, String ... classes) throws IOException {
        SetMode newMode = RawFactory.eINSTANCE.createSetMode();
        newMode.getWidgetClasses().addAll(Arrays.asList(classes));
        newMode.setMode(mode);
        try {
            DataSerializer.writeEObject(this.output, newMode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeEObject(EObject object) throws IOException {
        DataSerializer.writeEObject(this.output, object);
    }

    public EObject readEObject() throws IOException {
        return DataSerializer.readEObject(this.input);
    }
}

