/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.AbstractPatternNodeVisitor;
import org.aspectj.weaver.patterns.BindingAnnotationFieldTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.WildTypePattern;

public class VoidArrayFinder
extends AbstractPatternNodeVisitor {
    boolean found = false;
    PatternNode foundNode = null;

    public boolean hasVoidArray() {
        return this.found;
    }

    public PatternNode getFoundNode() {
        return this.foundNode;
    }

    @Override
    public Object visit(ExactTypePattern node, Object data) {
        if (this.found) {
            return node;
        }
        UnresolvedType exactType = node.getExactType();
        if (exactType != null && exactType.isArray() && exactType.toString().startsWith("void[")) {
            this.found = true;
            this.foundNode = node;
        }
        return node;
    }

    @Override
    public Object visit(WildTypePattern node, Object data) {
        if (!this.found && node.isArray() && node.toString().startsWith("void[")) {
            this.found = true;
            this.foundNode = node;
        }
        if (!this.found && node.getLowerBound() != null) {
            node.getLowerBound().accept(this, data);
        }
        if (!this.found && node.getUpperBound() != null) {
            node.getUpperBound().accept(this, data);
        }
        if (this.found) {
            return node;
        }
        TypePattern[] additionalIntefaceBounds = node.getAdditionalIntefaceBounds();
        if (additionalIntefaceBounds != null) {
            for (TypePattern typePattern : additionalIntefaceBounds) {
                if (this.found) break;
                typePattern.accept(this, data);
            }
        }
        return node;
    }

    @Override
    public Object visit(ExactAnnotationTypePattern node, Object data) {
        UnresolvedType exactType;
        if (!this.found && (exactType = node.getAnnotationType()) != null && exactType.isArray() && exactType.toString().startsWith("void[")) {
            this.found = true;
            this.foundNode = node;
        }
        return node;
    }

    public Object visit(BindingAnnotationFieldTypePattern node, Object data) {
        UnresolvedType exactType;
        if (!this.found && (exactType = node.getAnnotationType()) != null && exactType.isArray() && exactType.toString().startsWith("void[")) {
            this.found = true;
            this.foundNode = node;
        }
        return node;
    }

    @Override
    public Object visit(BindingAnnotationTypePattern node, Object data) {
        UnresolvedType exactType;
        if (!this.found && (exactType = node.getAnnotationType()) != null && exactType.isArray() && exactType.toString().startsWith("void[")) {
            this.found = true;
            this.foundNode = node;
        }
        return node;
    }
}

