/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.util.Locale;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.support.FieldContext;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.ConversionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
implements ArgumentConverter {
    public static final String DEFAULT_LOCALE_CONVERSION_FORMAT_PROPERTY_NAME = "junit.jupiter.params.arguments.conversion.locale.format";
    private static final Function<String, LocaleConversionFormat> TRANSFORMER = value -> LocaleConversionFormat.valueOf(value.trim().toUpperCase(Locale.ROOT));
    private final ExtensionContext context;

    public DefaultArgumentConverter(ExtensionContext context) {
        this.context = context;
    }

    @Override
    public final Object convert(Object source, ParameterContext context) {
        Class<?> targetType = context.getParameter().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getDeclaringExecutable().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    @Override
    public final Object convert(Object source, FieldContext context) throws ArgumentConversionException {
        Class<?> targetType = context.getField().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getField().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    public final Object convert(Object source, Class<?> targetType, ClassLoader classLoader) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getTypeName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo((Object)source, targetType)) {
            return source;
        }
        if (source instanceof String) {
            if (targetType == Locale.class && this.getLocaleConversionFormat() == LocaleConversionFormat.BCP_47) {
                return Locale.forLanguageTag((String)source);
            }
            try {
                return this.convert((String)source, targetType, classLoader);
            }
            catch (ConversionException ex) {
                throw new ArgumentConversionException(ex.getMessage(), ex);
            }
        }
        throw new ArgumentConversionException(String.format("No built-in converter for source type %s and target type %s", source.getClass().getTypeName(), targetType.getTypeName()));
    }

    private LocaleConversionFormat getLocaleConversionFormat() {
        return this.context.getConfigurationParameter(DEFAULT_LOCALE_CONVERSION_FORMAT_PROPERTY_NAME, TRANSFORMER).orElse(LocaleConversionFormat.BCP_47);
    }

    Object convert(String source, Class<?> targetType, ClassLoader classLoader) {
        return ConversionSupport.convert((String)source, targetType, (ClassLoader)classLoader);
    }

    static enum LocaleConversionFormat {
        BCP_47,
        ISO_639;

    }
}

