/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.ChangeRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension2;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IOverviewRulerExtension;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.quickdiff.CompositeRevertAction;
import org.eclipse.ui.internal.editors.quickdiff.RestoreAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertBlockAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertLineAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertSelectionAction;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.RefreshEditorAction;
import org.eclipse.ui.internal.texteditor.AnnotationColumn;
import org.eclipse.ui.internal.texteditor.BooleanPreferenceToggleAction;
import org.eclipse.ui.internal.texteditor.FocusedInformationPresenter;
import org.eclipse.ui.internal.texteditor.LineNumberColumn;
import org.eclipse.ui.internal.texteditor.TextChangeHover;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLinesProviderRegistry;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingHandler;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AddMarkerAction;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.RevisionHoverInformationControlCreator;
import org.eclipse.ui.texteditor.ShowWhitespaceCharactersAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnPreferenceAdapter;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;
import org.eclipse.ui.views.markers.MarkerViewUtil;

public abstract class AbstractDecoratedTextEditor
extends StatusTextEditor {
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String OVERVIEW_RULER = "overviewRuler";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String INLINE_ANNOTATION_COLOR = "org.eclipse.ui.editors.inlineAnnotationColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    private static final String PRINT_MARGIN_ALLOW_OVERRIDE = "printMarginAllowOverride";
    private static final String DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    public static final String DEFAULT_OVERVIEW_RULER_CONTEXT_MENU_ID = "#OverviewRulerContext";
    private static final String USE_SATURATED_COLORS_IN_OVERVIEW_RULER = "Accessibility.UseSaturatedColors";
    private MarkerAnnotationPreferences fAnnotationPreferences;
    protected IOverviewRuler fOverviewRuler;
    private String fOverviewRulerContextMenuId;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected LineNumberRulerColumn fLineNumberRulerColumn;
    private LineNumberColumn fLineColumn;
    private IDocumentProvider fImplicitDocumentProvider;
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    protected boolean fIsUpdatingMarkerViews = false;
    private boolean fIsComingFromGotoMarker = false;
    private boolean fIsEditingDerivedFileAllowed = true;
    private boolean fIsDerivedStateValidated = false;
    private FocusedInformationPresenter fInformationPresenter;
    private StickyScrollingHandler fStickyScrollingHandler;

    private IVerticalRuler internalGetVerticalRuler() {
        return this.getVerticalRuler();
    }

    public AbstractDecoratedTextEditor() {
        this.fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.initializeKeyBindingScopes();
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fLineNumberRulerColumn = null;
        this.fLineColumn = null;
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        if (this.fStickyScrollingHandler != null) {
            this.fStickyScrollingHandler.uninstall();
            this.fStickyScrollingHandler = null;
        }
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer viewer = new SourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        Iterator<AnnotationPreference> e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference(e.next());
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        support.setInlineAnnotationColorPreferenceKey(INLINE_ANNOTATION_COLOR);
    }

    public void createPartControl(Composite parent) {
        IOverviewRuler iOverviewRuler;
        RulerColumnDescriptor lineNumberColumnDescriptor;
        super.createPartControl(parent);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (this.isLineNumberRulerVisible() && (lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers")) != null) {
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, true);
        }
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
        if ((iOverviewRuler = this.fOverviewRuler) instanceof IOverviewRulerExtension) {
            IOverviewRulerExtension rulerEx = (IOverviewRulerExtension)iOverviewRuler;
            rulerEx.setUseSaturatedColors(this.isPrefUseSaturatedColorsOn());
        }
        if (!this.isOverwriteModeEnabled()) {
            this.enableOverwriteMode(false);
        }
        if (!this.isRangeIndicatorEnabled()) {
            this.getSourceViewer().removeRangeIndication();
            this.getSourceViewer().setRangeIndicator(null);
        }
        ISourceViewer viewer = this.getSourceViewer();
        IAnnotationAccess iAnnotationAccess = this.fAnnotationAccess;
        if (iAnnotationAccess instanceof IAnnotationAccessExtension2) {
            IAnnotationAccessExtension2 annotationEx2 = (IAnnotationAccessExtension2)iAnnotationAccess;
            if (viewer instanceof ISourceViewerExtension3) {
                ISourceViewerExtension3 viewerEx3 = (ISourceViewerExtension3)viewer;
                annotationEx2.setQuickAssistAssistant(viewerEx3.getQuickAssistAssistant());
            }
        }
        this.createOverviewRulerContextMenu();
        if (this.isStickyScrollingEnabled()) {
            IStickyLinesProvider stickyLineProvider = this.getStickyLinesProvider();
            this.fStickyScrollingHandler = new StickyScrollingHandler(this.getSourceViewer(), this.getVerticalRuler(), this.getPreferenceStore(), stickyLineProvider, (IEditorPart)this);
        }
    }

    private boolean isStickyScrollingEnabled() {
        return this.getPreferenceStore().getBoolean("stickyScrollingEnabled");
    }

    private IStickyLinesProvider getStickyLinesProvider() {
        StickyLinesProviderRegistry stickyLinesProviderRegistry = new StickyLinesProviderRegistry();
        return stickyLinesProviderRegistry.getProvider(this.getSourceViewer(), (ITextEditor)this);
    }

    protected void createOverviewRulerContextMenu() {
        if (this.fOverviewRulerContextMenuId == null) {
            this.fOverviewRulerContextMenuId = DEFAULT_OVERVIEW_RULER_CONTEXT_MENU_ID;
        }
        if (this.fOverviewRuler == null || this.fOverviewRuler.getControl() == null) {
            return;
        }
        MenuManager menuManager = new MenuManager(this.fOverviewRulerContextMenuId, this.fOverviewRulerContextMenuId);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getContextMenuListener());
        Menu menu = menuManager.createContextMenu(this.getOverviewRuler().getControl());
        this.getOverviewRuler().getControl().setMenu(menu);
        this.getEditorSite().registerContextMenu(this.fOverviewRulerContextMenuId, menuManager, this.getSelectionProvider(), false);
    }

    protected IMenuListener createContextMenuListener() {
        IMenuListener superListener = super.createContextMenuListener();
        return menu -> {
            if (!this.getOverviewRulerContextMenuId().equals(menu.getId())) {
                superListener.menuAboutToShow(menu);
                return;
            }
            this.setFocus();
            this.overviewRulerContextMenuAboutToShow(menu);
        };
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        IEncodingSupport adapter = this.getAdapter(IEncodingSupport.class);
        DefaultEncodingSupport encodingSupport = null;
        if (adapter instanceof DefaultEncodingSupport) {
            DefaultEncodingSupport enc;
            encodingSupport = enc = (DefaultEncodingSupport)adapter;
        }
        if (encodingSupport == null || !encodingSupport.isEncodingError(status)) {
            return super.createStatusControl(parent, status);
        }
        Shell shell = this.getSite().getShell();
        Display display = shell.getDisplay();
        Color bgColor = display.getSystemColor(25);
        Color fgColor = display.getSystemColor(24);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setBackground(bgColor);
        composite.setForeground(fgColor);
        Control control = super.createStatusControl(composite, status);
        control.setLayoutData((Object)new GridData(768));
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData(1808));
        buttonComposite.setBackground(bgColor);
        buttonComposite.setForeground(fgColor);
        encodingSupport.createStatusEncodingChangeControl(buttonComposite, status);
        return composite;
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(OVERVIEW_RULER) : false;
    }

    public void showChangeInformation(boolean show) {
        if (show == this.isChangeInformationShowing()) {
            return;
        }
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (show && this.fLineColumn == null) {
            RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
            if (lineNumberColumnDescriptor != null) {
                columnSupport.setColumnVisible(lineNumberColumnDescriptor, true);
            }
        } else if (!show && this.fLineColumn != null && !this.isLineNumberRulerVisible()) {
            columnSupport.setColumnVisible(this.fLineColumn.getDescriptor(), false);
            this.fLineColumn = null;
        }
    }

    public boolean isChangeInformationShowing() {
        return this.fLineColumn != null && this.fLineColumn.isShowingChangeInformation();
    }

    public void showRevisionInformation(RevisionInformation info, String quickDiffProviderId) {
        if (info.getHoverControlCreator() == null) {
            info.setHoverControlCreator((IInformationControlCreator)new RevisionHoverInformationControlCreator(false));
        }
        if (info.getInformationPresenterControlCreator() == null) {
            info.setInformationPresenterControlCreator((IInformationControlCreator)new RevisionHoverInformationControlCreator(true));
        }
        this.showChangeInformation(true);
        if (this.fLineColumn != null) {
            this.fLineColumn.showRevisionInformation(info, quickDiffProviderId);
        }
    }

    protected boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(LINE_NUMBER_RULER) : false;
    }

    protected boolean isOverwriteModeEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? !store.getBoolean(DISABLE_OVERWRITE_MODE) : true;
    }

    private boolean isRangeIndicatorEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean("show_range_indicator") : true;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        boolean setting;
        IPreferenceStore store = this.getPreferenceStore();
        boolean bl = setting = store != null ? store.getBoolean("quickdiff.quickDiff") : false;
        return setting && this.isEditorInputModifiable();
    }

    private boolean isPrefUseSaturatedColorsOn() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(USE_SATURATED_COLORS_IN_OVERVIEW_RULER) : false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        if (this.fLineColumn != null) {
            this.fLineColumn.initializeLineNumberRulerColumn(rulerColumn);
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberChangeRulerColumn(this.getSharedColors());
        ((IChangeRulerColumn)this.fLineNumberRulerColumn).setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected LineChangeHover createChangeHover() {
        return new TextChangeHover();
    }

    @Deprecated
    protected IChangeRulerColumn createChangeRulerColumn() {
        return new ChangeRulerColumn(this.getSharedColors());
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.createCompositeRuler();
    }

    protected CompositeRuler createCompositeRuler() {
        return new CompositeRuler();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        return new AnnotationRulerColumn(12, this.getAnnotationAccess());
    }

    protected final IColumnSupport createColumnSupport() {
        return new AbstractTextEditor.ColumnSupport((AbstractTextEditor)this, RulerColumnRegistry.getDefault()){

            protected void initializeColumn(IContributedRulerColumn column) {
                super.initializeColumn(column);
                RulerColumnDescriptor descriptor = column.getDescriptor();
                IVerticalRuler ruler = AbstractDecoratedTextEditor.this.internalGetVerticalRuler();
                if (ruler instanceof CompositeRuler) {
                    CompositeRuler compRuler = (CompositeRuler)ruler;
                    if ("org.eclipse.ui.editors.columns.annotations".equals(descriptor.getId())) {
                        ((AnnotationColumn)column).setDelegate(AbstractDecoratedTextEditor.this.createAnnotationRulerColumn(compRuler));
                    } else if ("org.eclipse.ui.editors.columns.linenumbers".equals(descriptor.getId())) {
                        AbstractDecoratedTextEditor.this.fLineColumn = (LineNumberColumn)column;
                        AbstractDecoratedTextEditor.this.fLineColumn.setForwarder(new LineNumberColumn.ICompatibilityForwarder(){

                            @Override
                            public IVerticalRulerColumn createLineNumberRulerColumn() {
                                return AbstractDecoratedTextEditor.this.createLineNumberRulerColumn();
                            }

                            @Override
                            public boolean isQuickDiffEnabled() {
                                return AbstractDecoratedTextEditor.this.isPrefQuickDiffAlwaysOn();
                            }

                            @Override
                            public boolean isLineNumberRulerVisible() {
                                return AbstractDecoratedTextEditor.this.isLineNumberRulerVisible();
                            }
                        });
                    }
                }
            }

            public void dispose() {
                AbstractDecoratedTextEditor.this.fLineColumn = null;
                super.dispose();
            }
        };
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            IPreferenceStore store;
            IOverviewRuler iOverviewRuler;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            String property = event.getProperty();
            if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(property)) {
                if (this.isOverviewRulerVisible()) {
                    this.showOverviewRuler();
                } else {
                    this.hideOverviewRuler();
                }
                return;
            }
            if (USE_SATURATED_COLORS_IN_OVERVIEW_RULER.equals(property) && (iOverviewRuler = this.fOverviewRuler) instanceof IOverviewRulerExtension) {
                IOverviewRulerExtension overviewRulerEx = (IOverviewRulerExtension)iOverviewRuler;
                overviewRulerEx.setUseSaturatedColors(this.isPrefUseSaturatedColorsOn());
                this.fOverviewRuler.update();
            }
            if (DISABLE_OVERWRITE_MODE.equals(property)) {
                this.enableOverwriteMode(this.isOverwriteModeEnabled());
                return;
            }
            if (LINE_NUMBER_RULER.equals(property)) {
                IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
                if (this.isLineNumberRulerVisible() && this.fLineColumn == null) {
                    RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
                    if (lineNumberColumnDescriptor != null) {
                        columnSupport.setColumnVisible(lineNumberColumnDescriptor, true);
                    }
                } else if (!this.isLineNumberRulerVisible() && this.fLineColumn != null && !this.fLineColumn.isShowingChangeInformation()) {
                    columnSupport.setColumnVisible(this.fLineColumn.getDescriptor(), false);
                    this.fLineColumn = null;
                }
                return;
            }
            if ("quickdiff.quickDiff".equals(property)) {
                this.showChangeInformation(this.isPrefQuickDiffAlwaysOn());
            }
            if ("tabWidth".equals(property)) {
                store = this.getPreferenceStore();
                if (store != null) {
                    sourceViewer.getTextWidget().setTabs(store.getInt("tabWidth"));
                }
                if (this.isTabsToSpacesConversionEnabled()) {
                    this.uninstallTabsToSpacesConverter();
                    this.installTabsToSpacesConverter();
                }
                return;
            }
            if ("lineSpacing".equals(property)) {
                store = this.getPreferenceStore();
                if (store != null) {
                    int linespace = this.getSourceViewerConfiguration().getLineSpacing(sourceViewer);
                    sourceViewer.getTextWidget().setLineSpacing(linespace);
                }
                return;
            }
            if ("spacesForTabs".equals(property) || "removeSpacesAsTabs".equals(property)) {
                if (this.isTabsToSpacesConversionEnabled()) {
                    this.installTabsToSpacesConverter();
                } else {
                    this.uninstallTabsToSpacesConverter();
                }
                return;
            }
            if ("undoHistorySize".equals(property) && sourceViewer instanceof ITextViewerExtension6) {
                ITextViewerExtension6 sourceViewerExt6 = (ITextViewerExtension6)sourceViewer;
                IPreferenceStore store2 = this.getPreferenceStore();
                if (store2 != null) {
                    sourceViewerExt6.getUndoManager().setMaximalUndoLevel(store2.getInt("undoHistorySize"));
                }
                return;
            }
            if ("show_range_indicator".equals(property)) {
                if (this.isRangeIndicatorEnabled()) {
                    this.getSourceViewer().setRangeIndicator(this.getRangeIndicator());
                } else {
                    this.getSourceViewer().removeRangeIndication();
                    this.getSourceViewer().setRangeIndicator(null);
                }
            }
            if (sourceViewer instanceof ITextViewerExtension6) {
                HyperlinkDetectorDescriptor[] descriptor;
                ITextViewerExtension6 textViewer6 = (ITextViewerExtension6)sourceViewer;
                HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = descriptor = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
                int n = descriptor.length;
                int n2 = 0;
                while (n2 < n) {
                    HyperlinkDetectorDescriptor d = hyperlinkDetectorDescriptorArray[n2];
                    if (d.getId().equals(property) || (d.getId() + "_stateMask").equals(property)) {
                        IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors(sourceViewer);
                        int stateMask = this.getSourceViewerConfiguration().getHyperlinkStateMask(sourceViewer);
                        textViewer6.setHyperlinkDetectors(detectors, stateMask);
                        return;
                    }
                    ++n2;
                }
            }
            if ("stickyScrollingEnabled".equals(property)) {
                IPreferenceStore store3 = this.getPreferenceStore();
                if (store3 == null) {
                    return;
                }
                if (store3.getBoolean("stickyScrollingEnabled")) {
                    IStickyLinesProvider stickyLineProvider = this.getStickyLinesProvider();
                    this.fStickyScrollingHandler = new StickyScrollingHandler(this.getSourceViewer(), this.getVerticalRuler(), this.getPreferenceStore(), stickyLineProvider, (IEditorPart)this);
                    this.fStickyScrollingHandler.viewportChanged(this.getSourceViewer().getTextWidget().getTopPixel());
                } else if (this.fStickyScrollingHandler != null) {
                    this.fStickyScrollingHandler.uninstall();
                    this.fStickyScrollingHandler = null;
                }
                return;
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void showOverviewRuler() {
        ISourceViewer iSourceViewer;
        if (this.fOverviewRuler != null && (iSourceViewer = this.getSourceViewer()) instanceof ISourceViewerExtension) {
            ISourceViewerExtension sourceViewerExt = (ISourceViewerExtension)iSourceViewer;
            sourceViewerExt.showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ISourceViewerExtension) {
            ISourceViewerExtension sourceViewerExt = (ISourceViewerExtension)iSourceViewer;
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            sourceViewerExt.showAnnotationsOverview(false);
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
            if (!this.getPreferenceStore().getBoolean(PRINT_MARGIN_ALLOW_OVERRIDE)) {
                this.fSourceViewerDecorationSupport.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
            }
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return this.fAnnotationPreferences;
    }

    @Deprecated
    public void gotoMarker(IMarker marker) {
        int length;
        if (this.fIsUpdatingMarkerViews) {
            return;
        }
        if (this.getSourceViewer() == null) {
            return;
        }
        int start = MarkerUtilities.getCharStart(marker);
        int end = MarkerUtilities.getCharEnd(marker);
        boolean selectLine = start < 0 || end < 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                start = pos.getOffset();
                end = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return;
            }
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (selectLine) {
            try {
                int line;
                if (start >= 0) {
                    line = document.getLineOfOffset(start);
                } else {
                    line = MarkerUtilities.getLineNumber(marker);
                    start = document.getLineOffset(--line);
                }
                end = start + document.getLineLength(line) - 1;
            }
            catch (BadLocationException e) {
                return;
            }
        }
        if (end <= (length = document.getLength()) && start <= length) {
            this.fIsComingFromGotoMarker = true;
            this.selectAndReveal(start, end - start);
        }
    }

    public boolean isEditable() {
        if (!super.isEditable()) {
            return false;
        }
        return this.fIsEditingDerivedFileAllowed;
    }

    public boolean validateEditorInputState() {
        if (!super.validateEditorInputState()) {
            return false;
        }
        return this.validateEditorInputDerived();
    }

    private boolean validateEditorInputDerived() {
        if (this.fIsDerivedStateValidated) {
            return this.fIsEditingDerivedFileAllowed;
        }
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider instanceof IDocumentProviderExtension) {
            boolean isDerivedStatus;
            IDocumentProviderExtension extension = (IDocumentProviderExtension)iDocumentProvider;
            IStatus status = extension.getStatus((Object)this.getEditorInput());
            String pluginId = status.getPlugin();
            boolean bl = isDerivedStatus = status.getCode() == 5 && ("org.eclipse.core.filebuffers".equals(pluginId) || "org.eclipse.ui.editors".equals(pluginId));
            if (!isDerivedStatus) {
                return true;
            }
        }
        String warnKey = "warn_if_input_derived";
        IPreferenceStore store = this.getPreferenceStore();
        if (!store.getBoolean("warn_if_input_derived")) {
            return true;
        }
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getSite().getShell(), (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_title, (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_message, (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_dontShowAgain, (boolean)false, null, null);
        EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !toggleDialog.getToggleState());
        this.fIsDerivedStateValidated = true;
        this.fIsEditingDerivedFileAllowed = toggleDialog.getReturnCode() == 2;
        return this.fIsEditingDerivedFileAllowed;
    }

    protected boolean isErrorStatus(IStatus status) {
        IStatus[] childrenStatus;
        if (!super.isErrorStatus(status)) {
            return false;
        }
        if (!status.isMultiStatus()) {
            return !this.isReadOnlyLocalStatus(status);
        }
        IStatus[] iStatusArray = childrenStatus = status.getChildren();
        int n = childrenStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus childrenStatu = iStatusArray[n2];
            if (childrenStatu.getSeverity() == 4 && !this.isReadOnlyLocalStatus(childrenStatu)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isReadOnlyLocalStatus(IStatus status) {
        return status.getCode() == 279;
    }

    protected void createActions() {
        super.createActions();
        Object action = new AddMarkerAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddBookmark.", (ITextEditor)this, "org.eclipse.core.resources.bookmark", true);
        action.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.setAction(IDEActionFactory.BOOKMARK.getId(), (IAction)action);
        action = new AddTaskAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddTask.", (ITextEditor)this);
        action.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)action);
        action = new ChangeEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.", (ITextEditor)this);
        action.setHelpContextId("org.eclipse.ui.ChangeEncoding_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.changeEncoding");
        this.setAction("ChangeEncoding", (IAction)action);
        this.markAsPropertyDependentAction("ChangeEncoding", true);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleLineNumbersAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleLineNumberRuler();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.editors.lineNumberToggle");
        this.setAction("Linenumbers.Toggle", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleQuickDiffAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleQuickDiffRuler();
            }
        };
        action.setActionDefinitionId("org.eclipse.quickdiff.toggle");
        this.setAction("QuickDiff.Toggle", (IAction)action);
        action = new RevertLineAction((ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revertLine");
        this.setAction("QuickDiff.RevertLine", (IAction)action);
        action = new RevertSelectionAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertSelection", (IAction)action);
        action = new RevertBlockAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertBlock", (IAction)action);
        action = new RestoreAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertDeletion", (IAction)action);
        CompositeRevertAction action2 = new CompositeRevertAction((ITextEditor)this, new IAction[]{this.getAction("QuickDiff.RevertSelection"), this.getAction("QuickDiff.RevertBlock"), this.getAction("QuickDiff.RevertDeletion"), this.getAction("QuickDiff.RevertLine")});
        action2.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revert");
        this.setAction("QuickDiff.Revert", (IAction)action2);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.HideRevisionInformationAction."){

            public void run() {
                if (AbstractDecoratedTextEditor.this.fLineColumn != null) {
                    AbstractDecoratedTextEditor.this.fLineColumn.hideRevisionInformation();
                }
            }
        };
        this.setAction("Revision.HideInfo", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.CycleRevisionRenderingAction."){

            public void run() {
                IRevisionRulerColumnExtension.RenderingMode[] modes = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
                IPreferenceStore store = EditorsUI.getPreferenceStore();
                String current = store.getString("revisionRulerRenderingMode");
                int i = 0;
                while (i < modes.length) {
                    String mode = modes[i].name();
                    if (mode.equals(current)) {
                        int nextIndex = (i + 1) % modes.length;
                        IRevisionRulerColumnExtension.RenderingMode nextMode = modes[nextIndex];
                        store.setValue("revisionRulerRenderingMode", nextMode.name());
                    }
                    ++i;
                }
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.rendering.cycle");
        this.setAction("Revision.Rendering.Cycle", (IAction)action);
        action = new BooleanPreferenceToggleAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleRevisionAuthorAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowAuthor");
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.author.toggle");
        this.setAction("Revision.ShowAuthor.Toggle", (IAction)action);
        action = new BooleanPreferenceToggleAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleRevisionIdAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowRevision");
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.id.toggle");
        this.setAction("Revision.ShowId.Toggle", (IAction)action);
        final Shell shell = this.getSourceViewer() != null ? this.getSourceViewer().getTextWidget().getShell() : null;
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] preferencePages = AbstractDecoratedTextEditor.this.collectRulerMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        };
        this.setAction("Preferences.RulerAction", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ContextPreferencesAction."){

            public void run() {
                String[] preferencePages = AbstractDecoratedTextEditor.this.collectContextMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        };
        this.setAction("Preferences.ContextAction", (IAction)action);
        IAction showWhitespaceCharactersAction = this.getAction("ShowWhitespaceCharacters");
        if (showWhitespaceCharactersAction instanceof ShowWhitespaceCharactersAction) {
            ShowWhitespaceCharactersAction act = (ShowWhitespaceCharactersAction)showWhitespaceCharactersAction;
            act.setPreferenceStore(EditorsUI.getPreferenceStore());
        }
        this.setAction(ITextEditorActionConstants.REFRESH, (IAction)new RefreshEditorAction((ITextEditor)this));
        this.markAsPropertyDependentAction(ITextEditorActionConstants.REFRESH, true);
        if (this.getAction(ITextEditorActionConstants.PRINT).isEnabled() && this.getSourceViewer() instanceof ITextViewerExtension8) {
            this.createPrintAction();
        }
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowChangeRulerInformation.", 1){

            public void run() {
                AbstractDecoratedTextEditor.this.showChangeRulerInformation();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showChangeRulerInformation");
        this.setAction("ShowChangeRulerInformation", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowRulerAnnotationInformation.", 1){

            public void run() {
                AbstractDecoratedTextEditor.this.showRulerAnnotationInformation();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showRulerAnnotationInformation");
        this.setAction("ShowRulerAnnotationInformation", (IAction)action);
    }

    private void showChangeRulerInformation() {
        CompositeRuler compositeRuler;
        block3: {
            block2: {
                IVerticalRuler ruler = this.getVerticalRuler();
                if (!(ruler instanceof CompositeRuler)) break block2;
                compositeRuler = (CompositeRuler)ruler;
                if (this.fLineColumn != null) break block3;
            }
            return;
        }
        int x = this.fLineColumn.getControl().getLocation().x;
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText textWidget = sourceViewer.getTextWidget();
        int caretOffset = textWidget.getCaretOffset();
        int caretLine = textWidget.getLineAtOffset(caretOffset);
        int y = textWidget.getLinePixel(caretLine);
        compositeRuler.setLocationOfLastMouseButtonActivity(x, y);
        IAnnotationHover hover = this.fLineColumn.getHover();
        this.showFocusedRulerHover(hover, sourceViewer, caretOffset);
    }

    private void showRulerAnnotationInformation() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        IAnnotationHover hover = this.getSourceViewerConfiguration().getAnnotationHover(sourceViewer);
        int caretOffset = sourceViewer.getTextWidget().getCaretOffset();
        this.showFocusedRulerHover(hover, sourceViewer, caretOffset);
    }

    private void showFocusedRulerHover(IAnnotationHover hover, ISourceViewer sourceViewer, int caretOffset) {
        if (hover == null) {
            return;
        }
        int modelCaretOffset = AbstractDecoratedTextEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)caretOffset);
        if (modelCaretOffset == -1) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        try {
            int line = document.getLineOfOffset(modelCaretOffset);
            if (this.fInformationPresenter == null) {
                this.fInformationPresenter = new FocusedInformationPresenter(sourceViewer, this.getSourceViewerConfiguration());
            }
            this.fInformationPresenter.openFocusedAnnotationHover(hover, line);
        }
        catch (BadLocationException e) {
            return;
        }
    }

    private void createPrintAction() {
        final ISourceViewer viewer = this.getSourceViewer();
        ResourceAction action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.Print."){

            public void run() {
                StyledTextPrintOptions options = new StyledTextPrintOptions();
                options.printTextFontStyle = true;
                options.printTextForeground = true;
                options.printTextBackground = true;
                options.jobName = AbstractDecoratedTextEditor.this.getTitle();
                options.header = AbstractDecoratedTextEditor.this.getTitle() + "\t\t" + DateFormat.getDateTimeInstance(0, 3).format(new Date());
                options.footer = "\t" + NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_printPageNumber, "<page>");
                if (AbstractDecoratedTextEditor.this.isLineNumberRulerVisible()) {
                    options.printLineNumbers = true;
                    options.lineLabels = new String[viewer.getTextWidget().getLineCount()];
                    int i = 0;
                    while (i < options.lineLabels.length) {
                        options.lineLabels[i] = String.valueOf(JFaceTextUtil.widgetLine2ModelLine((ITextViewer)viewer, (int)i) + 1);
                        ++i;
                    }
                }
                ((ITextViewerExtension8)viewer).print(options);
            }
        };
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PRINT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)action);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IGotoMarker.class.equals(adapter)) {
            return (T)this.fGotoMarkerAdapter;
        }
        if (IAnnotationAccess.class.equals(adapter)) {
            return (T)this.getAnnotationAccess();
        }
        if (adapter == IShowInSource.class) {
            return (T)((IShowInSource)() -> {
                ISelection selection = null;
                ISelectionProvider selectionProvider = this.getSelectionProvider();
                if (selectionProvider != null) {
                    selection = selectionProvider.getSelection();
                }
                return new ShowInContext((Object)this.getEditorInput(), selection);
            });
        }
        if (IRevisionRulerColumn.class.equals(adapter) && this.fLineNumberRulerColumn instanceof IRevisionRulerColumn) {
            return (T)this.fLineNumberRulerColumn;
        }
        if (MarkerAnnotationPreferences.class.equals(adapter)) {
            return (T)EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        }
        if (IShowInTargetList.class.equals(adapter)) {
            return (T)this.getShowInTargetList();
        }
        return (T)super.getAdapter(adapter);
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider instanceof ForwardingDocumentProvider) {
            ForwardingDocumentProvider forwarder = (ForwardingDocumentProvider)provider;
            forwarder.setParentProvider(this.fImplicitDocumentProvider);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider == null) {
            return this.fImplicitDocumentProvider;
        }
        return provider;
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.fImplicitDocumentProvider = null;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.fIsDerivedStateValidated = false;
        this.fIsEditingDerivedFileAllowed = true;
        if (this.fLineColumn != null) {
            this.fLineColumn.hideRevisionInformation();
        }
        super.doSetInput(input);
        RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
        if (lineNumberColumnDescriptor != null) {
            IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, this.isLineNumberRulerVisible() || this.isPrefQuickDiffAlwaysOn());
        }
    }

    protected void handleEditorInputChanged() {
        IDocumentProvider provider = this.getDocumentProvider();
        IEditorInput input = this.getEditorInput();
        if (provider != null && input != null && !this.isDirty() && input.getAdapter(IFile.class) != null && Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null)) {
            return;
        }
        super.handleEditorInputChanged();
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block28: {
            Object newInput;
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            if (input instanceof IURIEditorInput && !(input instanceof IFileEditorInput)) {
                IFileStore fileStore;
                MessageDialog overwriteDialog;
                String path;
                dialog = new FileDialog(shell, 8192);
                IPath oldPath = URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
                if (oldPath != null && !oldPath.isEmpty()) {
                    dialog.setFileName(oldPath.lastSegment());
                    dialog.setFilterPath(oldPath.removeLastSegments(1).toOSString());
                }
                if ((path = dialog.open()) == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                File localFile = new File(path);
                if (localFile.exists() && (overwriteDialog = new MessageDialog(shell, TextEditorMessages.AbstractDecoratedTextEditor_saveAs_overwrite_title, null, NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_saveAs_overwrite_message, path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                    return;
                }
                try {
                    fileStore = EFS.getStore((URI)localFile.toURI());
                }
                catch (CoreException ex) {
                    EditorsPlugin.log(ex.getStatus());
                    String title = TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_title;
                    String msg = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_message, ex.getMessage());
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    return;
                }
                file = this.getWorkspaceFile(fileStore);
                newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
            } else {
                IFile original;
                dialog = new SaveAsDialog(shell);
                if (input instanceof IFileEditorInput) {
                    IFileEditorInput fileEditorInput = (IFileEditorInput)input;
                    v0 = fileEditorInput.getFile();
                } else {
                    v0 = original = null;
                }
                if (original != null) {
                    dialog.setOriginalFile(original);
                } else {
                    dialog.setOriginalName(input.getName());
                }
                dialog.create();
                if (provider.isDeleted((Object)input) && original != null) {
                    String message = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_warning_saveAs_deleted, original.getName());
                    dialog.setErrorMessage(null);
                    dialog.setMessage(message, 2);
                }
                if (dialog.open() == 1) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IPath filePath = dialog.getResult();
                if (filePath == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                file = workspace.getRoot().getFile(filePath);
                newInput = new FileEditorInput(file);
            }
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange(newInput);
                    provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_title;
                        String msg = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_message, x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                provider.changed(newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed(newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected void openSaveErrorDialog(String title, String message, CoreException exception) {
        IStatus status = exception.getStatus();
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (status.getCode() != 3 || !(documentProvider instanceof IStorageDocumentProvider)) {
            super.openSaveErrorDialog(title, message, exception);
            return;
        }
        int saveAsUTF8ButtonId = 2;
        int selectUnmappableCharButtonId = 3;
        final Charset charset = this.getCharset();
        ErrorDialog errorDialog = new ErrorDialog(this.getSite().getShell(), title, message, status, 4){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.createButton(parent, 2, TextEditorMessages.AbstractDecoratedTextEditor_save_error_Dialog_button_saveAsUTF8, false);
                if (charset != null) {
                    this.createButton(parent, 3, TextEditorMessages.AbstractDecoratedTextEditor_save_error_Dialog_button_selectUnmappable, false);
                }
            }

            protected void buttonPressed(int id) {
                if (id == 2 || id == 3) {
                    this.setReturnCode(id);
                    this.close();
                } else {
                    super.buttonPressed(id);
                }
            }

            protected boolean shouldShowDetailsButton() {
                return false;
            }
        };
        int returnCode = errorDialog.open();
        if (returnCode == 2) {
            ((IStorageDocumentProvider)documentProvider).setEncoding(this.getEditorInput(), StandardCharsets.UTF_8.name());
            IProgressMonitor monitor = this.getProgressMonitor();
            try {
                this.doSave(monitor);
            }
            finally {
                monitor.done();
            }
        } else if (returnCode == 3) {
            CharsetEncoder encoder = charset.newEncoder();
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int documentLength = document.getLength();
            int offset = 0;
            BreakIterator charBreakIterator = BreakIterator.getCharacterInstance();
            charBreakIterator.setText(document.get());
            while (offset < documentLength) {
                try {
                    int next = charBreakIterator.next();
                    String ch = document.get(offset, next - offset);
                    if (!encoder.canEncode(ch)) {
                        this.selectAndReveal(offset, next - offset);
                        return;
                    }
                    offset = next;
                }
                catch (BadLocationException ex) {
                    EditorsPlugin.log(ex);
                }
            }
        }
    }

    private Charset getCharset() {
        IEncodingSupport encodingSupport = this.getAdapter(IEncodingSupport.class);
        if (encodingSupport == null) {
            return null;
        }
        try {
            return Charset.forName(encodingSupport.getEncoding());
        }
        catch (UnsupportedCharsetException ex) {
            return null;
        }
        catch (IllegalCharsetNameException ex) {
            return null;
        }
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    protected void setOverviewRulerContextMenuId(String contextMenuId) {
        Assert.isNotNull((Object)contextMenuId);
        this.fOverviewRulerContextMenuId = contextMenuId;
    }

    protected final String getOverviewRulerContextMenuId() {
        return this.fOverviewRulerContextMenuId;
    }

    protected void overviewRulerContextMenuAboutToShow(IMenuManager menu) {
        final String preferenceLabel = this.findSelectedOverviewRulerAnnotationLabel();
        final Shell shell = this.getSite().getShell();
        ResourceAction action = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] preferencePages = AbstractDecoratedTextEditor.this.collectOverviewRulerMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, (Object)preferenceLabel).open();
                }
            }
        };
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)action);
    }

    private String findSelectedOverviewRulerAnnotationLabel() {
        AnnotationPreference ap;
        IAnnotationModel model = this.getSourceViewer().getAnnotationModel();
        if (model == null) {
            return null;
        }
        Point selection = this.getSourceViewer().getSelectedRange();
        Annotation annotation = null;
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            annotation = (Annotation)iter.next();
            Position p = model.getPosition(annotation);
            if (p.getOffset() == selection.x && p.getLength() == selection.y) break;
        }
        if (annotation != null && (ap = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation)) != null) {
            return ap.getPreferenceLabel();
        }
        return null;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("debug"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("restore"));
        menu.add((IContributionItem)new Separator("add"));
        menu.add((IContributionItem)new Separator("rulers"));
        menu.add((IContributionItem)new Separator("group.rest"));
        super.rulerContextMenuAboutToShow(menu);
        this.addRulerContributionActions(menu);
        if (this.isEditorInputModifiable()) {
            IAction quickdiffAction = this.getAction("QuickDiff.Toggle");
            quickdiffAction.setChecked(this.isChangeInformationShowing());
            menu.appendToGroup("rulers", quickdiffAction);
            if (this.isChangeInformationShowing()) {
                RevertLineAction revertLine = new RevertLineAction((ITextEditor)this, true);
                RevertSelectionAction revertSelection = new RevertSelectionAction((ITextEditor)this, true);
                RevertBlockAction revertBlock = new RevertBlockAction((ITextEditor)this, true);
                RestoreAction revertDeletion = new RestoreAction((ITextEditor)this, true);
                revertSelection.update();
                revertBlock.update();
                revertLine.update();
                revertDeletion.update();
                if (revertSelection.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertSelection);
                } else if (revertBlock.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertBlock);
                }
                if (revertLine.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertLine);
                }
                if (revertDeletion.isEnabled()) {
                    menu.appendToGroup("restore", (IAction)revertDeletion);
                }
            }
        }
        if (this.fLineColumn != null && this.fLineColumn.isShowingRevisionInformation()) {
            MenuManager revisionMenu = new MenuManager(TextEditorMessages.AbstractDecoratedTextEditor_revisions_menu);
            menu.appendToGroup("rulers", (IContributionItem)revisionMenu);
            IAction hideRevisionInfoAction = this.getAction("Revision.HideInfo");
            revisionMenu.add(hideRevisionInfoAction);
            revisionMenu.add((IContributionItem)new Separator());
            String[] labels = new String[]{TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_date, TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_author, TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_author_and_date};
            IRevisionRulerColumnExtension.RenderingMode[] modes = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
            final IPreferenceStore uiStore = EditorsUI.getPreferenceStore();
            String current = uiStore.getString("revisionRulerRenderingMode");
            int i = 0;
            while (i < modes.length) {
                final String mode = modes[i].name();
                Action action = new Action(labels[i], 8){

                    public void run() {
                        uiStore.setValue("revisionRulerRenderingMode", mode);
                    }
                };
                action.setChecked(mode.equals(current));
                revisionMenu.add((IAction)action);
                ++i;
            }
            revisionMenu.add((IContributionItem)new Separator());
            IAction action = this.getAction("Revision.ShowAuthor.Toggle");
            if (action instanceof IUpdate) {
                IUpdate updateAction = (IUpdate)action;
                updateAction.update();
            }
            revisionMenu.add(action);
            action = this.getAction("Revision.ShowId.Toggle");
            if (action instanceof IUpdate) {
                IUpdate updateAction = (IUpdate)action;
                updateAction.update();
            }
            revisionMenu.add(action);
        }
        IAction lineNumberAction = this.getAction("Linenumbers.Toggle");
        lineNumberAction.setChecked(this.fLineColumn != null && this.fLineColumn.isShowingLineNumbers());
        menu.appendToGroup("rulers", lineNumberAction);
        IAction preferencesAction = this.getAction("Preferences.RulerAction");
        menu.appendToGroup("rulers", (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    private void addRulerContributionActions(IMenuManager menu) {
        final IColumnSupport support = this.getAdapter(IColumnSupport.class);
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        final RulerColumnPreferenceAdapter adapter = new RulerColumnPreferenceAdapter(store, "rulerContributions");
        for (final RulerColumnDescriptor descriptor : RulerColumnRegistry.getDefault().getColumnDescriptors()) {
            if (!descriptor.isIncludedInMenu() || !support.isColumnSupported(descriptor)) continue;
            final boolean isVisible = support.isColumnVisible(descriptor);
            Action action = new Action(MessageFormat.format(TextEditorMessages.AbstractDecoratedTextEditor_show_ruler_label, descriptor.getName()), 2){

                public void run() {
                    if (descriptor.isGlobal()) {
                        adapter.setEnabled(descriptor, !isVisible);
                    } else {
                        support.setColumnVisible(descriptor, !isVisible);
                    }
                }
            };
            action.setChecked(isVisible);
            action.setImageDescriptor(descriptor.getIcon());
            menu.appendToGroup("rulers", (IAction)action);
        }
    }

    private void toggleLineNumberRuler() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        store.setValue(LINE_NUMBER_RULER, !this.isLineNumberRulerVisible());
    }

    private void toggleQuickDiffRuler() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        boolean current = store.getBoolean("quickdiff.quickDiff");
        if (current == this.isChangeInformationShowing()) {
            store.setValue("quickdiff.quickDiff", !current);
        } else {
            this.showChangeInformation(current);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        menu.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
        menu.appendToGroup("group.save", (IContributionItem)new Separator("group.open"));
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput.getAdapter(IResource.class) instanceof IFile) {
            MenuManager openWithSubMenu = new MenuManager(TextEditorMessages.AbstractDecoratedTextEditor_openWith_menu);
            final IWorkbenchPage page = this.getEditorSite().getPage();
            openWithSubMenu.add((IContributionItem)new OpenWithMenu(page, (IAdaptable)editorInput){

                protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                    super.openEditor(editorDescriptor, openUsingDescriptor);
                    ISelection selection = AbstractDecoratedTextEditor.this.getSelectionProvider().getSelection();
                    if (selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        AbstractDecoratedTextEditor.revealInEditor(page.getActiveEditor(), textSelection.getOffset(), textSelection.getLength());
                    }
                }
            });
            menu.appendToGroup("group.open", (IContributionItem)openWithSubMenu);
        }
        MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getEditorSite().getWorkbenchWindow()));
        menu.appendToGroup("group.open", (IContributionItem)showInSubMenu);
    }

    private static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        IGotoMarker gotoMarkerTarget;
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            IGotoMarker gotoMarker;
            gotoMarkerTarget = gotoMarker = (IGotoMarker)editor;
        } else {
            IGotoMarker iGotoMarker = gotoMarkerTarget = editor != null ? (IGotoMarker)editor.getAdapter(IGotoMarker.class) : null;
        }
        if (gotoMarkerTarget != null && editor != null) {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IFileEditorInput fileInput = (IFileEditorInput)input;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = fileInput.getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException e) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
    }

    private String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_showIn_menu, keyBinding);
    }

    protected String[] createShowInTargetList() {
        return new String[]{"org.eclipse.ui.views.minimap.MinimapView"};
    }

    private IShowInTargetList getShowInTargetList() {
        String[] targetList = this.createShowInTargetList();
        if (targetList != null && targetList.length > 0) {
            return () -> targetList;
        }
        return null;
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage", "org.eclipse.ui.preferencePages.ColorsAndFonts"};
    }

    protected String[] collectRulerMenuPreferencePages() {
        return this.collectContextMenuPreferencePages();
    }

    protected String[] collectOverviewRulerMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.preferencePages.ColorsAndFonts"};
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext undoContext) {
        IEditorInput input = this.getEditorInput();
        if (input != null && input.getAdapter(IResource.class) != null) {
            return new NonLocalUndoUserApprover(undoContext, (IEditorPart)this, new Object[]{input}, IResource.class);
        }
        return super.getUndoRedoOperationApprover(undoContext);
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && this.getPreferenceStore().getBoolean(key);
    }

    public Annotation gotoAnnotation(boolean forward) {
        Annotation annotation = super.gotoAnnotation(forward);
        if (annotation != null) {
            this.updateMarkerViews(annotation);
        }
        return annotation;
    }

    protected void updateMarkerViews(Annotation annotation) {
        if (this.fIsComingFromGotoMarker) {
            this.fIsComingFromGotoMarker = false;
            return;
        }
        IMarker marker = null;
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            marker = markerAnnotation.getMarker();
        }
        if (marker != null) {
            try {
                this.fIsUpdatingMarkerViews = true;
                IWorkbenchPage page = this.getSite().getPage();
                MarkerViewUtil.showMarker((IWorkbenchPage)page, (IMarker)marker, (boolean)false);
            }
            finally {
                this.fIsUpdatingMarkerViews = false;
            }
        }
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean("spacesForTabs");
    }

    protected boolean isSpacesAsTabsDeletionEnabled() {
        return this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean("removeSpacesAsTabs");
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        private GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            AbstractDecoratedTextEditor.this.gotoMarker(marker);
        }
    }
}

