/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Get;
import org.eclipse.rcptt.ecl.dispatch.ServiceDispatchingUtils;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        IStatus result = ServiceDispatchingUtils.handleWithExtensions((Command)command, (IProcess)context);
        return result != null ? result : this.defaultService(command, context);
    }

    private IStatus defaultService(Command command, IProcess context) throws InterruptedException, CoreException {
        Get get = (Get)command;
        EObject input = get.getInput();
        Object propertyObject = BoxedValues.unbox((Object)get.getKey());
        if (!(propertyObject instanceof String)) {
            return OperationsPlugin.createErr("Key must be string when getting member value from EObject", new Object[0]);
        }
        String name = (String)propertyObject;
        if (input == null) {
            return OperationsPlugin.createErr("No input", new Object[0]);
        }
        EStructuralFeature feature = input.eClass().getEStructuralFeature(name);
        if (feature == null) {
            return OperationsPlugin.createErr("Input object of type %s does not have member %s", input.eClass().getName(), name);
        }
        Object result = input.eGet(feature);
        if (result == null) {
            if (get.getDefault() != null) {
                result = get.getDefault();
            } else {
                return OperationsPlugin.createErr("%s has null value and default argument is not set", name);
            }
        }
        if (result instanceof List) {
            for (Object item : (List)result) {
                context.getOutput().write(item);
            }
        } else if (result instanceof Enum) {
            context.getOutput().write((Object)((Enum)result).name());
        } else {
            context.getOutput().write(result);
        }
        return Status.OK_STATUS;
    }
}

