/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.projectsettings;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.projectsettings.Q7ProjectEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class Q7ProjectEditor
extends NamedElementEditor {
    Q7ProjectEditorPage page;

    public IQ7ProjectMetadata getModel() {
        return (IQ7ProjectMetadata)super.getModel();
    }

    public ProjectMetadata getElement() {
        return (ProjectMetadata)super.getElement();
    }

    @Override
    protected void updateElement() throws ModelException, PartInitException {
        super.updateElement();
        this.updateEditorTitle();
    }

    @Override
    protected void updateEditorTitle() {
        this.setPartName(this.getModel().getQ7Project().getName() + " - Project Settings");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.updateEditorTitle();
    }

    protected void addPages() {
        try {
            this.page = new Q7ProjectEditorPage(this);
            this.addPage((IFormPage)this.page);
        }
        catch (PartInitException e) {
            Q7UIPlugin.log(e);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.page.updateContent();
        super.doSave(monitor);
    }

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() < 2) {
            this.hideTabs();
        }
    }

    @Override
    public void createActions() {
        this.actions = new NamedElementEditorActions(new NamedElementEditorActions.INamedElementActions(){

            private boolean isContextsFocus() {
                return Q7ProjectEditor.this.page.getContextTable().getControl().isFocusControl();
            }

            private boolean isVerificationFocus() {
                return Q7ProjectEditor.this.page.getVerificationsTable().getControl().isFocusControl();
            }

            private boolean isDescriptionFocus() {
                return Q7ProjectEditor.this.page.getDescriptionComposite().getDescriptionControl().isFocusControl();
            }

            @Override
            public void undo() {
                if (this.isDescriptionFocus()) {
                    Q7ProjectEditor.this.page.getDescriptionComposite().getActions().undo();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void redo() {
                if (this.isDescriptionFocus()) {
                    Q7ProjectEditor.this.page.getDescriptionComposite().getActions().redo();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void paste() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().paste();
                } else if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().paste();
                } else if (this.isDescriptionFocus()) {
                    Q7ProjectEditor.this.page.getDescriptionComposite().getActions().paste();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void cut() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().cut();
                } else if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().cut();
                } else if (this.isDescriptionFocus()) {
                    Q7ProjectEditor.this.page.getDescriptionComposite().getActions().cut();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public void copy() {
                if (this.isContextsFocus()) {
                    Q7ProjectEditor.this.page.getContextTable().copy();
                } else if (this.isVerificationFocus()) {
                    Q7ProjectEditor.this.page.getVerificationsTable().copy();
                } else if (this.isDescriptionFocus()) {
                    Q7ProjectEditor.this.page.getDescriptionComposite().getActions().copy();
                }
                Q7ProjectEditor.this.updateEnablement();
            }

            @Override
            public boolean canUndo() {
                if (this.isDescriptionFocus()) {
                    return Q7ProjectEditor.this.page.getDescriptionComposite().getActions().canUndo();
                }
                return false;
            }

            @Override
            public boolean canRedo() {
                if (this.isDescriptionFocus()) {
                    return Q7ProjectEditor.this.page.getDescriptionComposite().getActions().canRedo();
                }
                return false;
            }

            @Override
            public boolean canPaste() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canPaste();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canPaste();
                }
                if (this.isDescriptionFocus()) {
                    return Q7ProjectEditor.this.page.getDescriptionComposite().getActions().canPaste();
                }
                return false;
            }

            @Override
            public boolean canCut() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canCut();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canCut();
                }
                if (this.isDescriptionFocus()) {
                    return Q7ProjectEditor.this.page.getDescriptionComposite().getActions().canCut();
                }
                return false;
            }

            @Override
            public boolean canCopy() {
                if (this.isContextsFocus()) {
                    return Q7ProjectEditor.this.page.getContextTable().canCopy();
                }
                if (this.isVerificationFocus()) {
                    return Q7ProjectEditor.this.page.getVerificationsTable().canCopy();
                }
                if (this.isDescriptionFocus()) {
                    return Q7ProjectEditor.this.page.getDescriptionComposite().getActions().canCopy();
                }
                return false;
            }
        }, this.getEditorSite().getActionBars());
    }

    @Override
    protected void afterMissingReferencesAdded() {
        this.page.refreshPage();
    }
}

