/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Utils {
    public static IStatus closeDialogs() {
        return Utils.doCloseDialogs();
    }

    private static IStatus doCloseDialogs() {
        SWTDialogManager.setCancelMessageBoxesDisplay((boolean)true);
        try {
            Shell shell;
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            workbench.getActiveWorkbenchWindow();
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            HashSet<Shell> windowShells = new HashSet<Shell>();
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                shell = window.getShell();
                if (shell != null) {
                    windowShells.add(shell);
                }
                ++n2;
            }
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Thread t : map.keySet()) {
                Display dd = Display.findDisplay((Thread)t);
                if (dd == null || dd.equals(display)) continue;
                t.interrupt();
            }
            MultiStatus status = new MultiStatus("org.eclipse.rcptt.tesla.ecl.impl", 123131, "Failed to close dialogs", null);
            Shell[] shells = display.getShells();
            int i = shells.length - 1;
            while (i >= 0) {
                shell = shells[i];
                if (!windowShells.contains(shell) && !shell.isDisposed() && shell.isVisible()) {
                    Object data = shell.getData();
                    if (data != null && data instanceof WizardDialog) {
                        try {
                            ProgressMonitorPart part;
                            WizardDialog dialog = (WizardDialog)data;
                            if (TeslaSWTAccess.getWizardDialogHasActiveOperations((WizardDialog)dialog) && (part = TeslaSWTAccess.getProgressMonitorPart((WizardDialog)dialog)) != null) {
                                part.setCanceled(true);
                                part.clearBlocked();
                            }
                            TeslaSWTAccess.setWizardDialogHasActiveOperations((WizardDialog)dialog, (long)0L);
                            Utils.pressCancel(dialog);
                            if (!shell.isDisposed()) {
                                dialog.close();
                            }
                        }
                        catch (Throwable e) {
                            TeslaCore.log((Throwable)e);
                            status.add(Utils.createStatusForInternalAutFailure(e));
                        }
                    } else {
                        shell.close();
                    }
                    if (!shell.isDisposed() && shell.isVisible()) {
                        status.add((IStatus)new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", String.format("Shell with name %s and class %s is not disposed and visible", shell.getText(), shell.getClass().getName())));
                    }
                }
                --i;
            }
            if (status.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            SWTDialogManager.setCancelMessageBoxesDisplay((boolean)false);
        }
    }

    private static IStatus createStatusForInternalAutFailure(Throwable e) {
        return new Status(4, "org.eclipse.rcptt.ecl.core", 123131, "Internal aut failure. Cause: " + e.getMessage(), e);
    }

    private static void pressCancel(WizardDialog dialog) {
        Button cancelButton = TeslaSWTAccess.getWizardDialogButton((WizardDialog)dialog, (int)1);
        if (cancelButton == null) {
            return;
        }
        cancelButton.notifyListeners(13, new Event());
    }
}

