/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.util.CharArray;
import org.eclipse.jdt.internal.compiler.util.CharCharArray;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.AdditionalTypeCollection;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathJrtWithReleaseOption;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.CompressedReader;
import org.eclipse.jdt.internal.core.builder.CompressedWriter;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;
import org.eclipse.jdt.internal.core.util.Util;

public class State {
    String javaProjectName;
    public ClasspathMultiDirectory[] sourceLocations;
    public ClasspathMultiDirectory[] testSourceLocations;
    public ClasspathLocation[] binaryLocations;
    public ClasspathLocation[] testBinaryLocations;
    Map<String, ReferenceCollection> references;
    public Map<String, String> typeLocators;
    int buildNumber;
    long lastStructuralBuildTime;
    HashMap<String, Long> structuralBuildTimes;
    private String[] knownPackageNames;
    private long previousStructuralBuildTime;
    private StringSet structurallyChangedTypes;
    public static int MaxStructurallyChangedTypes = 100;
    public static final byte VERSION = 38;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;
    private static final int[] PROBLEM_IDS;

    static {
        int[] nArray = new int[5];
        nArray[1] = 0x1000133;
        nArray[2] = 0x1000118;
        nArray[3] = 0x3000133;
        nArray[4] = 50331928;
        PROBLEM_IDS = nArray;
    }

    State() {
    }

    protected State(JavaBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = -1L;
        this.structurallyChangedTypes = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.binaryLocations = javaBuilder.nameEnvironment.binaryLocations;
        this.testSourceLocations = javaBuilder.testNameEnvironment.sourceLocations;
        this.testBinaryLocations = javaBuilder.testNameEnvironment.binaryLocations;
        this.references = new LinkedHashMap<String, ReferenceCollection>(7);
        this.typeLocators = new LinkedHashMap<String, String>(7);
        this.buildNumber = 0;
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(javaBuilder.lastState == null ? 0L : javaBuilder.lastState.lastStructuralBuildTime);
        this.structuralBuildTimes = new HashMap();
    }

    long computeStructuralBuildTime(long previousTime) {
        long newTime = System.currentTimeMillis();
        if (newTime <= previousTime) {
            newTime = previousTime + 1L;
        }
        return newTime;
    }

    void copyFrom(State lastState) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = lastState.previousStructuralBuildTime;
        this.structurallyChangedTypes = lastState.structurallyChangedTypes;
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        this.references = new LinkedHashMap<String, ReferenceCollection>(lastState.references);
        this.typeLocators = new LinkedHashMap<String, String>(lastState.typeLocators);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof State)) {
            return false;
        }
        State other = (State)obj;
        return this.buildNumber == other.buildNumber && this.lastStructuralBuildTime == other.lastStructuralBuildTime && Objects.equals(this.javaProjectName, other.javaProjectName) && Arrays.equals(this.sourceLocations, other.sourceLocations) && Arrays.equals(this.binaryLocations, other.binaryLocations) && Arrays.equals(this.testSourceLocations, other.testSourceLocations) && Arrays.equals(this.testBinaryLocations, other.testBinaryLocations) && Objects.equals(this.typeLocators, other.typeLocators) && Objects.equals(this.references, other.references);
    }

    public int hashCode() {
        return 31 + Objects.hash(this.javaProjectName);
    }

    public char[][] getDefinedTypeNamesFor(String typeLocator) {
        ReferenceCollection c = this.references.get(typeLocator);
        if (c instanceof AdditionalTypeCollection) {
            return ((AdditionalTypeCollection)c).definedTypeNames;
        }
        return null;
    }

    public Map<String, ReferenceCollection> getReferences() {
        return this.references;
    }

    StringSet getStructurallyChangedTypes(State prereqState) {
        if (prereqState != null && prereqState.previousStructuralBuildTime > 0L) {
            long previous;
            Long o = this.structuralBuildTimes.get(prereqState.javaProjectName);
            long l = previous = o == null ? 0L : o;
            if (previous == prereqState.previousStructuralBuildTime) {
                return prereqState.structurallyChangedTypes;
            }
        }
        return null;
    }

    public boolean isDuplicateLocator(String qualifiedTypeName, String typeLocator) {
        String existing = this.typeLocators.get(qualifiedTypeName);
        return existing != null && !existing.equals(typeLocator);
    }

    public boolean isKnownPackage(String qualifiedPackageName) {
        int result;
        if (this.knownPackageNames == null) {
            LinkedHashSet<String> names = new LinkedHashSet<String>(this.typeLocators.size());
            Set<Map.Entry<String, String>> keyTable = this.typeLocators.entrySet();
            for (Map.Entry<String, String> entry : keyTable) {
                String packageName = entry.getKey();
                int last = packageName.lastIndexOf(47);
                packageName = last == -1 ? null : packageName.substring(0, last);
                while (packageName != null && !names.contains(packageName)) {
                    names.add(packageName);
                    last = packageName.lastIndexOf(47);
                    String string = packageName = last == -1 ? null : packageName.substring(0, last);
                }
            }
            this.knownPackageNames = new String[names.size()];
            names.toArray(this.knownPackageNames);
            Arrays.sort(this.knownPackageNames);
        }
        return (result = Arrays.binarySearch(this.knownPackageNames, qualifiedPackageName)) >= 0;
    }

    public boolean isKnownType(String qualifiedTypeName) {
        return this.typeLocators.containsKey(qualifiedTypeName);
    }

    boolean isSourceFolderEmpty(IContainer sourceFolder) {
        String sourceFolderName = sourceFolder.getProjectRelativePath().addTrailingSeparator().toString();
        for (String value : this.typeLocators.values()) {
            if (!value.startsWith(sourceFolderName)) continue;
            return false;
        }
        return true;
    }

    void record(String typeLocator, char[][][] qualifiedRefs, char[][] simpleRefs, char[][] rootRefs, char[] mainTypeName, ArrayList typeNames) {
        if (typeNames.size() == 1 && CharOperation.equals((char[])mainTypeName, (char[])((char[])typeNames.get(0)))) {
            this.references.put(typeLocator, new ReferenceCollection(qualifiedRefs, simpleRefs, rootRefs));
        } else {
            char[][] definedTypeNames = new char[typeNames.size()][];
            typeNames.toArray((T[])definedTypeNames);
            this.references.put(typeLocator, new AdditionalTypeCollection(definedTypeNames, qualifiedRefs, simpleRefs, rootRefs));
        }
    }

    void recordLocatorForType(String qualifiedTypeName, String typeLocator) {
        this.knownPackageNames = null;
        int start = typeLocator.indexOf(qualifiedTypeName, 0);
        if (start > 0) {
            qualifiedTypeName = typeLocator.substring(start, start + qualifiedTypeName.length());
        }
        this.typeLocators.put(qualifiedTypeName, typeLocator);
    }

    void recordStructuralDependency(IProject prereqProject, State prereqState) {
        if (prereqState != null && prereqState.lastStructuralBuildTime > 0L) {
            this.structuralBuildTimes.put(prereqProject.getName(), prereqState.lastStructuralBuildTime);
        }
    }

    void removeLocator(String typeLocatorToRemove) {
        this.knownPackageNames = null;
        this.references.remove(typeLocatorToRemove);
        this.typeLocators.values().removeIf(v -> typeLocatorToRemove.equals(v));
    }

    void removePackage(IResourceDelta sourceDelta) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                IResourceDelta[] children;
                IResourceDelta[] iResourceDeltaArray = children = sourceDelta.getAffectedChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta child = iResourceDeltaArray[n2];
                    this.removePackage(child);
                    ++n2;
                }
                return;
            }
            case 1: {
                IPath typeLocatorPath = resource.getProjectRelativePath();
                if (!Util.isJavaLikeFileName(typeLocatorPath.lastSegment())) break;
                this.removeLocator(typeLocatorPath.toString());
            }
        }
    }

    void removeQualifiedTypeName(String qualifiedTypeNameToRemove) {
        this.knownPackageNames = null;
        this.typeLocators.remove(qualifiedTypeNameToRemove);
    }

    static State read(IProject project, DataInputStream input) throws IOException, CoreException {
        CompressedReader in = new CompressedReader(input);
        if (JavaBuilder.DEBUG) {
            JavaModelManager.trace("About to read state " + project.getName());
        }
        if (38 != in.readByte()) {
            if (JavaBuilder.DEBUG) {
                JavaModelManager.trace("Found non-compatible state version... answered null for " + project.getName());
            }
            return null;
        }
        State newState = new State();
        newState.javaProjectName = in.readStringUsingDictionary();
        if (!project.getName().equals(newState.javaProjectName)) {
            if (JavaBuilder.DEBUG) {
                JavaModelManager.trace("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        ArrayList<ClasspathLocation> allLocationsForEEA = null;
        if ("enabled".equals(JavaCore.create(project).getOption("org.eclipse.jdt.core.builder.annotationPath.allLocations", true))) {
            allLocationsForEEA = new ArrayList<ClasspathLocation>();
        }
        newState.sourceLocations = State.readSourceLocations(project, in, allLocationsForEEA);
        newState.binaryLocations = State.readBinaryLocations(project, in, newState.sourceLocations, allLocationsForEEA);
        newState.testSourceLocations = State.readSourceLocations(project, in, allLocationsForEEA);
        newState.testBinaryLocations = State.readBinaryLocations(project, in, newState.testSourceLocations, allLocationsForEEA);
        int length = in.readInt();
        newState.structuralBuildTimes = new HashMap(length);
        int i = 0;
        while (i < length) {
            newState.structuralBuildTimes.put(in.readStringUsingDictionary(), in.readLong());
            ++i;
        }
        length = in.readInt();
        String[] internedTypeLocators = new String[length];
        int i2 = 0;
        while (i2 < length) {
            internedTypeLocators[i2] = in.readStringUsingLast();
            ++i2;
        }
        length = in.readInt();
        newState.typeLocators = new LinkedHashMap<String, String>((int)((double)length / 0.75 + 1.0));
        i2 = 0;
        while (i2 < length) {
            newState.recordLocatorForType(in.readStringUsingLast(), internedTypeLocators[in.readIntInRange(internedTypeLocators.length)]);
            ++i2;
        }
        char[][] internedRootNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        char[][] internedSimpleNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        length = in.readInt();
        Object internedQualifiedNames = new char[length][][];
        int i3 = 0;
        while (i3 < length) {
            int qLength = in.readInt();
            char[][] qName = new char[qLength][];
            int j = 0;
            while (j < qLength) {
                qName[j] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
                ++j;
            }
            internedQualifiedNames[i3] = qName;
            ++i3;
        }
        internedQualifiedNames = ReferenceCollection.internQualifiedNames(internedQualifiedNames, false, false);
        length = in.readInt();
        newState.references = new LinkedHashMap<String, ReferenceCollection>((int)((double)length / 0.75 + 1.0));
        i3 = 0;
        while (i3 < length) {
            String typeLocator = internedTypeLocators[in.readInt()];
            ReferenceCollection collection = null;
            switch (in.readByte()) {
                case 1: {
                    char[][] additionalTypeNames = State.readNames(in);
                    char[][][] qualifiedNames = new char[in.readInt()][][];
                    int j = 0;
                    int m = qualifiedNames.length;
                    while (j < m) {
                        qualifiedNames[j] = internedQualifiedNames[in.readIntInRange(((char[][][])internedQualifiedNames).length)];
                        ++j;
                    }
                    char[][] simpleNames = new char[in.readInt()][];
                    int j2 = 0;
                    int m2 = simpleNames.length;
                    while (j2 < m2) {
                        simpleNames[j2] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
                        ++j2;
                    }
                    char[][] rootNames = new char[in.readInt()][];
                    int j3 = 0;
                    int m3 = rootNames.length;
                    while (j3 < m3) {
                        rootNames[j3] = internedRootNames[in.readIntInRange(internedRootNames.length)];
                        ++j3;
                    }
                    collection = new AdditionalTypeCollection(additionalTypeNames, qualifiedNames, simpleNames, rootNames);
                    break;
                }
                case 2: {
                    char[][][] qNames = new char[in.readInt()][][];
                    int j = 0;
                    int m = qNames.length;
                    while (j < m) {
                        qNames[j] = internedQualifiedNames[in.readIntInRange(((char[][][])internedQualifiedNames).length)];
                        ++j;
                    }
                    char[][] sNames = new char[in.readInt()][];
                    int j4 = 0;
                    int m4 = sNames.length;
                    while (j4 < m4) {
                        sNames[j4] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
                        ++j4;
                    }
                    char[][] rNames = new char[in.readInt()][];
                    int j5 = 0;
                    int m5 = rNames.length;
                    while (j5 < m5) {
                        rNames[j5] = internedRootNames[in.readIntInRange(internedRootNames.length)];
                        ++j5;
                    }
                    collection = new ReferenceCollection(qNames, sNames, rNames);
                }
            }
            newState.references.put(typeLocator, collection);
            ++i3;
        }
        if (JavaBuilder.DEBUG) {
            JavaModelManager.trace("Successfully read state for " + newState.javaProjectName);
        }
        return newState;
    }

    private static ClasspathMultiDirectory[] readSourceLocations(IProject project, CompressedReader in, List<ClasspathLocation> allLocationsForEEA) throws IOException {
        int length = in.readInt();
        ClasspathMultiDirectory[] sourceLocations = new ClasspathMultiDirectory[length];
        int i = 0;
        while (i < length) {
            IProject sourceFolder = project;
            IProject outputFolder = project;
            String folderName = in.readStringUsingDictionary();
            if (folderName.length() > 0) {
                sourceFolder = project.getFolder(folderName);
            }
            if ((folderName = in.readStringUsingDictionary()).length() > 0) {
                outputFolder = project.getFolder(folderName);
            }
            ClasspathMultiDirectory md = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)sourceFolder, (IContainer)outputFolder, State.readNames(in), State.readNames(in), in.readBoolean(), State.readNullablePath(in));
            if (in.readBoolean()) {
                md.hasIndependentOutputFolder = true;
            }
            sourceLocations[i] = md;
            if (allLocationsForEEA != null) {
                md.connectAllLocationsForEEA(allLocationsForEEA, true);
            }
            ++i;
        }
        return sourceLocations;
    }

    private static ClasspathLocation[] readBinaryLocations(IProject project, CompressedReader in, ClasspathMultiDirectory[] sourceLocations, ArrayList<ClasspathLocation> allLocationsForEEA) throws IOException, CoreException {
        int length = in.readInt();
        ClasspathLocation[] locations = new ClasspathLocation[length];
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        int i = 0;
        while (i < length) {
            char[] patchName;
            byte kind = in.readByte();
            switch (kind) {
                case 1: {
                    locations[i] = sourceLocations[in.readInt()];
                    break;
                }
                case 2: {
                    Path path = new Path(in.readStringUsingDictionary());
                    IFolder outputFolder = path.segmentCount() == 1 ? root.getProject(path.toString()) : root.getFolder((IPath)path);
                    locations[i] = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, in.readBoolean(), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean());
                    break;
                }
                case 3: {
                    String jarPath = in.readStringUsingDictionary();
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJrt((String)jarPath)) {
                        locations[i] = ClasspathLocation.forJrtSystem(jarPath, State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readStringUsingDictionary());
                        break;
                    }
                    locations[i] = ClasspathLocation.forLibrary(jarPath, in.readLong(), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean(), in.readStringUsingDictionary());
                    break;
                }
                case 4: {
                    locations[i] = ClasspathLocation.forLibrary(root.getFile((IPath)new Path(in.readStringUsingDictionary())), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean(), in.readStringUsingDictionary());
                }
            }
            ClasspathLocation loc = locations[i];
            if (allLocationsForEEA != null) {
                loc.connectAllLocationsForEEA(allLocationsForEEA, true);
            }
            loc.patchModuleName = (patchName = in.readChars()).length > 0 ? new String(patchName) : null;
            int limitSize = in.readInt();
            if (limitSize != 0) {
                loc.limitModuleNames = new LinkedHashSet<String>(limitSize);
                int j = 0;
                while (j < limitSize) {
                    loc.limitModuleNames.add(in.readStringUsingDictionary());
                    ++j;
                }
            } else {
                loc.limitModuleNames = null;
            }
            IUpdatableModule.UpdatesByKind updates = new IUpdatableModule.UpdatesByKind();
            List packageUpdates = null;
            int packageUpdatesSize = in.readInt();
            if (packageUpdatesSize != 0) {
                packageUpdates = updates.getList(IUpdatableModule.UpdateKind.PACKAGE, true);
                int j = 0;
                while (j < packageUpdatesSize) {
                    char[] pkgName = in.readChars();
                    char[][] targets = State.readNames(in);
                    packageUpdates.add(new IUpdatableModule.AddExports(pkgName, targets));
                    ++j;
                }
            }
            List moduleUpdates = null;
            int moduleUpdatesSize = in.readInt();
            if (moduleUpdatesSize != 0) {
                moduleUpdates = updates.getList(IUpdatableModule.UpdateKind.MODULE, true);
                char[] modName = in.readChars();
                moduleUpdates.add(new IUpdatableModule.AddReads(modName));
            }
            if (packageUpdates != null || moduleUpdates != null) {
                loc.updates = updates;
            }
            ++i;
        }
        return locations;
    }

    private static IPath readNullablePath(CompressedReader in) throws IOException {
        String path = in.readStringUsingDictionary();
        if (!path.isEmpty()) {
            return new Path(path);
        }
        return null;
    }

    private static AccessRuleSet readRestriction(CompressedReader in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        AccessRule[] accessRules = new AccessRule[length];
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            char[] pattern = in.readCharsUsingLast();
            int problemId = in.readIntWithHint(PROBLEM_IDS);
            accessRules[i] = manager.getAccessRuleForProblemId(pattern, problemId);
            ++i;
        }
        return new AccessRuleSet(accessRules, in.readByte(), DeduplicationUtil.intern(in.readStringUsingDictionary()));
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.previousStructuralBuildTime = this.lastStructuralBuildTime;
        this.structurallyChangedTypes = new StringSet(7);
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(this.previousStructuralBuildTime);
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Long o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void wasStructurallyChanged(String typeName) {
        if (this.structurallyChangedTypes != null) {
            if (this.structurallyChangedTypes.elementSize > MaxStructurallyChangedTypes) {
                this.structurallyChangedTypes = null;
            } else {
                this.structurallyChangedTypes.add(typeName);
            }
        }
    }

    void write(DataOutputStream output) throws IOException {
        int index;
        int n;
        Object object;
        CompressedWriter out = new CompressedWriter(output);
        out.writeByte(38);
        out.writeStringUsingDictionary(this.javaProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        this.writeSourceLocations(out, this.sourceLocations);
        this.writeBinaryLocations(out, this.binaryLocations, this.sourceLocations);
        this.writeSourceLocations(out, this.testSourceLocations);
        this.writeBinaryLocations(out, this.testBinaryLocations, this.testSourceLocations);
        out.writeInt(this.structuralBuildTimes.size());
        for (Map.Entry<String, Long> entry : this.structuralBuildTimes.entrySet()) {
            out.writeStringUsingDictionary(entry.getKey());
            out.writeLong(entry.getValue());
        }
        out.writeInt(this.references.size());
        HashMap<String, Integer> internedTypeLocators = new HashMap<String, Integer>(this.references.size());
        for (String string : this.references.keySet()) {
            out.writeStringUsingLast(string);
            internedTypeLocators.put(string, internedTypeLocators.size());
        }
        out.writeInt(this.typeLocators.size());
        for (Map.Entry entry : this.typeLocators.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            out.writeStringUsingLast(key);
            Integer index3 = (Integer)internedTypeLocators.get(value);
            out.writeIntInRange(index3, internedTypeLocators.size());
        }
        HashMap<CharArray, Integer> hashMap = new HashMap<CharArray, Integer>();
        HashMap<CharCharArray, Integer> internedQualifiedNames = new HashMap<CharCharArray, Integer>();
        HashMap<CharArray, Integer> internedSimpleNames = new HashMap<CharArray, Integer>();
        for (ReferenceCollection collection : this.references.values()) {
            object = collection.rootReferences;
            int n2 = collection.rootReferences.length;
            int n3 = 0;
            while (n3 < n2) {
                char[] cArray = object[n3];
                hashMap.putIfAbsent(new CharArray(cArray), hashMap.size());
                ++n3;
            }
            object = collection.qualifiedNameReferences;
            n2 = collection.qualifiedNameReferences.length;
            n3 = 0;
            while (n3 < n2) {
                char[] cArray = object[n3];
                if (internedQualifiedNames.putIfAbsent(new CharCharArray((char[][])cArray), internedQualifiedNames.size()) == null) {
                    char[] cArray2 = cArray;
                    n = cArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        char sName = cArray2[n4];
                        internedSimpleNames.putIfAbsent(new CharArray((char[])sName), internedSimpleNames.size());
                        ++n4;
                    }
                }
                ++n3;
            }
            object = collection.simpleNameReferences;
            n2 = collection.simpleNameReferences.length;
            n3 = 0;
            while (n3 < n2) {
                char[] cArray = object[n3];
                internedSimpleNames.putIfAbsent(new CharArray(cArray), internedSimpleNames.size());
                ++n3;
            }
        }
        char[][] internedArray = new char[hashMap.size()][];
        for (Map.Entry entry : hashMap.entrySet()) {
            int index2 = (Integer)entry.getValue();
            internedArray[index2] = ((CharArray)entry.getKey()).getKey();
        }
        this.writeNames(internedArray, out);
        internedArray = new char[internedSimpleNames.size()][];
        for (Map.Entry entry : internedSimpleNames.entrySet()) {
            int index2 = (Integer)entry.getValue();
            internedArray[index2] = ((CharArray)entry.getKey()).getKey();
        }
        this.writeNames(internedArray, out);
        char[][][] internedQArray = new char[internedQualifiedNames.size()][][];
        for (Map.Entry entry : internedQualifiedNames.entrySet()) {
            index = (Integer)entry.getValue();
            internedQArray[index] = ((CharCharArray)entry.getKey()).getKey();
        }
        out.writeInt(internedQArray.length);
        object = internedQArray;
        index = internedQArray.length;
        int n5 = 0;
        while (n5 < index) {
            char[] cArray = object[n5];
            int qLength = cArray.length;
            out.writeInt(qLength);
            char[] cArray3 = cArray;
            int n6 = cArray.length;
            n = 0;
            while (n < n6) {
                char qN = cArray3[n];
                Integer index4 = (Integer)internedSimpleNames.get(new CharArray((char[])qN));
                out.writeIntInRange(index4, internedSimpleNames.size());
                ++n;
            }
            ++n5;
        }
        out.writeInt(this.references.size());
        for (Map.Entry<String, ReferenceCollection> entry : this.references.entrySet()) {
            String key = entry.getKey();
            Integer index5 = (Integer)internedTypeLocators.get(key);
            out.writeInt(index5);
            ReferenceCollection collection = entry.getValue();
            if (collection instanceof AdditionalTypeCollection) {
                out.writeByte(1);
                AdditionalTypeCollection atc = (AdditionalTypeCollection)collection;
                this.writeNames(atc.definedTypeNames, out);
            } else {
                out.writeByte(2);
            }
            char[][][] qNames = collection.qualifiedNameReferences;
            int qLength = qNames.length;
            out.writeInt(qLength);
            char[][][] cArray = qNames;
            int index4 = qNames.length;
            int n7 = 0;
            while (n7 < index4) {
                char[][] qName2 = cArray[n7];
                Integer i = (Integer)internedQualifiedNames.get(new CharCharArray(qName2));
                out.writeIntInRange(i, internedQualifiedNames.size());
                ++n7;
            }
            char[][] sNames = collection.simpleNameReferences;
            int sLength = sNames.length;
            out.writeInt(sLength);
            char[][] cArray4 = sNames;
            int i = sNames.length;
            int n8 = 0;
            while (n8 < i) {
                char[] sName = cArray4[n8];
                Integer i2 = (Integer)internedSimpleNames.get(new CharArray(sName));
                out.writeIntInRange(i2, internedSimpleNames.size());
                ++n8;
            }
            char[][] rNames = collection.rootReferences;
            int rLength = rNames.length;
            out.writeInt(rLength);
            char[][] cArray5 = rNames;
            int n9 = rNames.length;
            int n10 = 0;
            while (n10 < n9) {
                char[] rName = cArray5[n10];
                Integer i3 = (Integer)hashMap.get(new CharArray(rName));
                out.writeIntInRange(i3, hashMap.size());
                ++n10;
            }
        }
    }

    private void writeSourceLocations(CompressedWriter out, ClasspathMultiDirectory[] srcLocations) throws IOException {
        out.writeInt(srcLocations.length);
        ClasspathMultiDirectory[] classpathMultiDirectoryArray = srcLocations;
        int n = srcLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathMultiDirectory md = classpathMultiDirectoryArray[n2];
            out.writeStringUsingDictionary(md.sourceFolder.getProjectRelativePath().toString());
            out.writeStringUsingDictionary(md.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(md.inclusionPatterns, out);
            this.writeNames(md.exclusionPatterns, out);
            out.writeBoolean(md.ignoreOptionalProblems);
            this.writeNullablePath(md.externalAnnotationPath, out);
            out.writeBoolean(md.hasIndependentOutputFolder);
            ++n2;
        }
    }

    private void writeBinaryLocations(CompressedWriter out, ClasspathLocation[] locations, ClasspathMultiDirectory[] srcLocations) throws IOException {
        out.writeInt(locations.length);
        ClasspathLocation[] classpathLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation c = classpathLocationArray[n2];
            if (c instanceof ClasspathMultiDirectory) {
                out.writeByte(1);
                int j = 0;
                int m = srcLocations.length;
                while (j < m) {
                    if (srcLocations[j] == c) {
                        out.writeInt(j);
                    }
                    ++j;
                }
            } else if (c instanceof ClasspathDirectory) {
                out.writeByte(2);
                ClasspathDirectory cd = (ClasspathDirectory)c;
                out.writeStringUsingDictionary(cd.binaryFolder.getFullPath().toString());
                out.writeBoolean(cd.isOutputFolder);
                this.writeRestriction(cd.accessRuleSet, out);
                this.writeNullablePath(cd.externalAnnotationPath, out);
                out.writeBoolean(cd.isOnModulePath);
            } else if (c instanceof ClasspathJar) {
                ClasspathJar jar = (ClasspathJar)c;
                if (jar.resource == null) {
                    out.writeByte(3);
                    out.writeStringUsingDictionary(jar.zipFilename);
                    out.writeLong(jar.lastModified());
                } else {
                    out.writeByte(4);
                    out.writeStringUsingDictionary(jar.resource.getFullPath().toString());
                }
                this.writeRestriction(jar.accessRuleSet, out);
                this.writeNullablePath(jar.externalAnnotationPath, out);
                out.writeBoolean(jar.isOnModulePath);
                out.writeStringUsingDictionary(jar.compliance == null ? "" : jar.compliance);
            } else if (c instanceof ClasspathJrt) {
                ClasspathJrt jrt = (ClasspathJrt)c;
                out.writeByte(3);
                out.writeStringUsingDictionary(jrt.zipFilename);
                this.writeRestriction(jrt.accessRuleSet, out);
                this.writeNullablePath(jrt.externalAnnotationPath, out);
                if (jrt instanceof ClasspathJrtWithReleaseOption) {
                    out.writeStringUsingDictionary(((ClasspathJrtWithReleaseOption)jrt).release);
                } else {
                    out.writeStringUsingDictionary("");
                }
            }
            char[] patchName = c.patchModuleName == null ? CharOperation.NO_CHAR : c.patchModuleName.toCharArray();
            out.writeChars(patchName);
            if (c.limitModuleNames != null) {
                out.writeInt(c.limitModuleNames.size());
                for (String name : c.limitModuleNames) {
                    out.writeStringUsingDictionary(name);
                }
            } else {
                out.writeInt(0);
            }
            if (c.updates != null) {
                List pu = c.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
                if (pu != null) {
                    Map<String, List<IUpdatableModule.AddExports>> map = pu.stream().filter(IUpdatableModule.AddExports.class::isInstance).map(IUpdatableModule.AddExports.class::cast).collect(Collectors.groupingBy(addExport -> CharOperation.charToString((char[])addExport.getName())));
                    out.writeInt(map.size());
                    map.entrySet().stream().forEach(entry -> {
                        String pkgName = (String)entry.getKey();
                        try {
                            out.writeChars(pkgName.toCharArray());
                            char[][] targetModules = ((List)entry.getValue()).stream().map(IUpdatableModule.AddExports::getTargetModules).filter(targets -> targets != null).reduce(CharOperation::arrayConcat).orElse(null);
                            this.writeNames(targetModules, out);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                } else {
                    out.writeInt(0);
                }
                List mu = c.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
                if (mu != null) {
                    List allReads = mu.stream().filter(IUpdatableModule.AddReads.class::isInstance).map(IUpdatableModule.AddReads.class::cast).collect(Collectors.toList());
                    out.writeInt(allReads.size());
                    for (IUpdatableModule.AddReads m : allReads) {
                        out.writeChars(m.getTarget());
                    }
                } else {
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
                out.writeInt(0);
            }
            ++n2;
        }
    }

    private void writeNames(char[][] names, CompressedWriter out) throws IOException {
        int length = names == null ? 0 : names.length;
        out.writeInt(length);
        if (names != null) {
            char[][] cArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                char[] name = cArray[n2];
                out.writeChars(name);
                ++n2;
            }
        }
    }

    private static char[][] readNames(CompressedReader in) throws IOException {
        int length = in.readInt();
        char[][] names = new char[length][];
        int i = 0;
        while (i < length) {
            names[i] = in.readChars();
            ++i;
        }
        return names;
    }

    private void writeNullablePath(String path, CompressedWriter out) throws IOException {
        out.writeStringUsingDictionary(path != null ? path : "");
    }

    private void writeRestriction(AccessRuleSet accessRuleSet, CompressedWriter out) throws IOException {
        if (accessRuleSet == null) {
            out.writeInt(0);
        } else {
            AccessRule[] accessRules = accessRuleSet.getAccessRules();
            int length = accessRules.length;
            out.writeInt(length);
            if (length != 0) {
                AccessRule[] accessRuleArray = accessRules;
                int n = accessRules.length;
                int n2 = 0;
                while (n2 < n) {
                    AccessRule accessRule = accessRuleArray[n2];
                    out.writeCharsUsingLast(accessRule.pattern);
                    out.writeIntWithHint(accessRule.problemId, PROBLEM_IDS);
                    ++n2;
                }
                out.writeByte(accessRuleSet.classpathEntryType);
                out.writeStringUsingDictionary(accessRuleSet.classpathEntryName);
            }
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + String.valueOf(new Date(this.lastStructuralBuildTime)) + ")";
    }
}

