/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.AllContextWithLinksQueryPattern;
import org.eclipse.rcptt.core.model.search.AllIDQueryPattern;
import org.eclipse.rcptt.core.model.search.AllNameQueryPattern;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.AllReferenceQueryPattern;
import org.eclipse.rcptt.core.model.search.AllTagQueryPattern;
import org.eclipse.rcptt.core.model.search.ContextRefSearchPattern;
import org.eclipse.rcptt.core.model.search.IDSearchPattern;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.KeyQueryPattern;
import org.eclipse.rcptt.core.model.search.NameSearchPattern;
import org.eclipse.rcptt.core.model.search.PathNameSearchPattern;
import org.eclipse.rcptt.core.model.search.PatternSearchJob;
import org.eclipse.rcptt.core.model.search.Q7NamedElementCollector;
import org.eclipse.rcptt.core.model.search.VerificationRefSearchPattern;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexManager;

public class Q7SearchCore {
    public static IQ7NamedElement[] findById(String id, ISearchScope scope, IProgressMonitor monitor) {
        return Q7SearchCore.findById(id, scope, monitor, -1L);
    }

    public static IQ7NamedElement findById(String id) {
        IQ7NamedElement[] result = Q7SearchCore.findById(id, new AllProjectScope(), (IProgressMonitor)new NullProgressMonitor());
        if (result.length != 1) {
            return null;
        }
        return result[0];
    }

    public static IQ7NamedElement[] findById(String id, ISearchScope scope, IProgressMonitor monitor, long timeout) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        Q7NamedElementCollector collector = new Q7NamedElementCollector();
        indexManager.performConcurrentJob(new PatternSearchJob(new IDSearchPattern(id), scope, collector), 3, monitor, timeout);
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        for (IQ7Element e : collector.getElements()) {
            if (!(e instanceof IQ7NamedElement)) continue;
            elements.add((IQ7NamedElement)e);
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] findByName(String name, ISearchScope scope, IProgressMonitor monitor) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        Q7NamedElementCollector collector = new Q7NamedElementCollector();
        indexManager.performConcurrentJob(new PatternSearchJob(new NameSearchPattern(name), scope, collector), 3, monitor);
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        for (IQ7Element e : collector.getElements()) {
            if (!(e instanceof IQ7NamedElement)) continue;
            elements.add((IQ7NamedElement)e);
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] findContextUsage(String cid, ISearchScope scope, IProgressMonitor monitor) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        Q7NamedElementCollector collector = new Q7NamedElementCollector();
        indexManager.performConcurrentJob(new PatternSearchJob(new ContextRefSearchPattern(cid), scope, collector), 3, monitor);
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        for (IQ7Element e : collector.getElements()) {
            if (!(e instanceof IQ7NamedElement)) continue;
            elements.add((IQ7NamedElement)e);
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] findVerificationUsage(String id, ISearchScope scope, IProgressMonitor monitor) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        Q7NamedElementCollector collector = new Q7NamedElementCollector();
        indexManager.performConcurrentJob(new PatternSearchJob(new VerificationRefSearchPattern(id), scope, collector), 3, monitor);
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        for (IQ7Element e : collector.getElements()) {
            if (!(e instanceof IQ7NamedElement)) continue;
            elements.add((IQ7NamedElement)e);
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] findElementsWithUnusedReferences(ISearchScope scope, IProgressMonitor monitor) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        HashSet<String> ids = new HashSet<String>(Arrays.asList(Q7SearchCore.findAllIDs(scope)));
        final ArrayList result = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new AllReferenceQueryPattern(ids, "ctx_ref", "verification_ref"), scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                result.add((IQ7NamedElement)q7Element);
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return result.toArray(new IQ7NamedElement[result.size()]);
    }

    public static IContext[] findContextsWithLinks(ISearchScope scope, Set<IPath> changed, IProgressMonitor monitor) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final ArrayList result = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new AllContextWithLinksQueryPattern(changed), scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                if (q7Element instanceof IContext) {
                    result.add((IContext)q7Element);
                }
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return result.toArray(new IContext[result.size()]);
    }

    public static String findNameByDocument(IQ7Element element) {
        if (element.getParent() != null) {
            final ArrayList names = new ArrayList();
            if (element.getQ7Project() == null) {
                return null;
            }
            IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
            final IPath path = element.getQ7Project().getPath();
            try {
                indexManager.performConcurrentJob(new PatternSearchJob(new PathNameSearchPattern(element.getPath().removeFirstSegments(path.segmentCount()).toString()), new ISearchScope(){

                    @Override
                    public IPath[] getPaths() {
                        return new IPath[]{path};
                    }

                    @Override
                    public boolean contains(IPath path2) {
                        return false;
                    }
                }, new IIndexRequestor(){

                    @Override
                    public void acceptMatch(IQ7Element q7Element, String key, String value) {
                        names.add(value);
                    }
                }), 2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException e) {
                return null;
            }
            if (names.size() == 1) {
                return (String)names.get(0);
            }
        }
        return null;
    }

    public static String[] findContextsByDocument(IQ7Element element) {
        if (element.getParent() != null) {
            String id = "ctx_ref";
            List<String> names = Q7SearchCore.findItemByDocument(element, id, false);
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    public static String[] findVerificationsByDocument(IQ7Element element) {
        if (element.getParent() != null) {
            String id = "verification_ref";
            List<String> names = Q7SearchCore.findItemByDocument(element, id, false);
            return names.toArray(new String[names.size()]);
        }
        return null;
    }

    private static List<String> findItemByDocument(IQ7Element element, String id, boolean allowCancel) {
        final ArrayList<String> names = new ArrayList<String>();
        if (element.getQ7Project() == null) {
            return names;
        }
        final IPath path = element.getQ7Project().getPath();
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        try {
            indexManager.performConcurrentJob(new PatternSearchJob(new KeyQueryPattern(element.getPath(), id), new ISearchScope(){

                @Override
                public IPath[] getPaths() {
                    return new IPath[]{path};
                }

                @Override
                public boolean contains(IPath path2) {
                    return false;
                }
            }, new IIndexRequestor(){

                @Override
                public void acceptMatch(IQ7Element q7Element, String key, String value) {
                    names.add(value);
                }
            }), allowCancel ? 2 : 3, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            return names;
        }
        return names;
    }

    private static List<String> findItemByPath(IPath elementPath, String id) {
        final ArrayList<String> names = new ArrayList<String>();
        Path path = new Path("/" + elementPath.segment(0));
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        indexManager.performConcurrentJob(new PatternSearchJob(new KeyQueryPattern(elementPath, id), new ISearchScope((IPath)path){
            private final /* synthetic */ IPath val$path;
            {
                this.val$path = iPath;
            }

            @Override
            public IPath[] getPaths() {
                return new IPath[]{this.val$path};
            }

            @Override
            public boolean contains(IPath path) {
                return false;
            }
        }, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                names.add(value);
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return names;
    }

    public static String findIDByDocument(IQ7Element element) {
        String id = "id";
        List<String> names = Q7SearchCore.findItemByDocument(element, id, true);
        if (names.size() == 1) {
            return names.get(0);
        }
        return null;
    }

    public static String findIDByPath(IPath path) {
        String id = "id";
        List<String> names = Q7SearchCore.findItemByPath(path, id);
        if (names.size() == 1) {
            return names.get(0);
        }
        return null;
    }

    public static Boolean findIsEmptyByDocument(IQ7Element element) {
        String id = "is_empty";
        List<String> names = Q7SearchCore.findItemByDocument(element, id, true);
        if (names.size() == 1) {
            return Boolean.valueOf(names.get(0));
        }
        return null;
    }

    public static String findContextTypeByDocument(IContext element) {
        String id = "context_type";
        List<String> names = Q7SearchCore.findItemByDocument(element, id, true);
        if (names.size() == 1) {
            return names.get(0);
        }
        return null;
    }

    public static String findVerificationTypeByDocument(IQ7Element element) {
        String id = "verification_type";
        List<String> names = Q7SearchCore.findItemByDocument(element, id, true);
        return names.size() == 1 ? names.get(0) : null;
    }

    public static String[] findTagsByDocument(IQ7Element element) {
        String id = "tags";
        List<String> names = Q7SearchCore.findItemByDocument(element, id, false);
        return names.toArray(new String[names.size()]);
    }

    public static String[] findAllNames(ISearchScope scope) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final ArrayList names = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new AllNameQueryPattern(), scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                names.add(value);
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return names.toArray(new String[names.size()]);
    }

    public static String[] findAllIDs(ISearchScope scope) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final ArrayList ids = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new AllIDQueryPattern(), scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                ids.add(value);
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return ids.toArray(new String[ids.size()]);
    }

    public static Map<IQ7NamedElement, List<String>> findAllTagReferences() {
        AllProjectScope scope = new AllProjectScope();
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final HashMap<IQ7NamedElement, List<String>> tagsRefs = new HashMap<IQ7NamedElement, List<String>>();
        indexManager.performConcurrentJob(new PatternSearchJob(new AllTagQueryPattern(), scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                if (q7Element instanceof IQ7NamedElement) {
                    IQ7NamedElement q7NamedElement = (IQ7NamedElement)q7Element;
                    ArrayList<String> tagList = (ArrayList<String>)tagsRefs.get(q7NamedElement);
                    if (tagList == null) {
                        tagList = new ArrayList<String>();
                    }
                    tagList.add(value);
                    tagsRefs.put(q7NamedElement, tagList);
                }
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return tagsRefs;
    }

    public static IQ7NamedElement[] findAllElements() {
        return Q7SearchCore.findAllElements(new AllProjectScope());
    }

    public static IQ7NamedElement[] findAllElements(ISearchScope scope) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final ArrayList names = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new ISearchPattern(){

            @Override
            public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
                String[] names;
                IPath path = index.getPath();
                String[] stringArray = names = index.queryDocumentNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    IQ7Element q7Element = RcpttCore.create(root.findMember(path.append((IPath)new Path(name))));
                    requestor.acceptMatch(q7Element, null, null);
                    ++n2;
                }
            }
        }, scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                if (q7Element instanceof IQ7NamedElement) {
                    names.add((IQ7NamedElement)q7Element);
                }
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return names.toArray(new IQ7NamedElement[names.size()]);
    }

    public static ITestSuite[] findAllTestSuites(ISearchScope scope) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final ArrayList result = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new ISearchPattern(){

            @Override
            public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
                String[] names;
                IPath path = index.getPath();
                String[] stringArray = names = index.queryDocumentNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    IQ7Element q7Element = RcpttCore.create(root.findMember(path.append((IPath)new Path(name))));
                    requestor.acceptMatch(q7Element, null, null);
                    ++n2;
                }
            }
        }, scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                if (q7Element instanceof ITestSuite) {
                    result.add((ITestSuite)q7Element);
                }
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return result.toArray(new ITestSuite[result.size()]);
    }

    public static IContext[] findAllContexts() {
        return Q7SearchCore.findAllContexts(new AllProjectScope());
    }

    public static IContext[] findAllContexts(ISearchScope scope) {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final ArrayList result = new ArrayList();
        indexManager.performConcurrentJob(new PatternSearchJob(new ISearchPattern(){

            @Override
            public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
                String[] names;
                IPath path = index.getPath();
                String[] stringArray = names = index.queryDocumentNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    IQ7Element q7Element = RcpttCore.create(root.findMember(path.append((IPath)new Path(name))));
                    requestor.acceptMatch(q7Element, null, null);
                    ++n2;
                }
            }
        }, scope, new IIndexRequestor(){

            @Override
            public void acceptMatch(IQ7Element q7Element, String key, String value) {
                if (q7Element instanceof IContext) {
                    result.add((IContext)q7Element);
                }
            }
        }), 3, (IProgressMonitor)new NullProgressMonitor());
        return result.toArray(new IContext[result.size()]);
    }

    public static IQ7NamedElement getTestSuiteItemElement(TestSuiteItem item, ISearchScope scope) {
        IQ7NamedElement[] elements = Q7SearchCore.findById(item.getNamedElementId(), scope, (IProgressMonitor)new NullProgressMonitor());
        if (elements.length == 1) {
            return elements[0];
        }
        return null;
    }

    public static IQ7NamedElement[] getTestSuiteContent(ITestSuite testSuite) throws ModelException {
        ISearchScope scope = Q7SearchCore.getSearchScope(testSuite);
        TestSuite modifiedTestSuite = (TestSuite)testSuite.getModifiedNamedElement();
        IQ7NamedElement[] content = new IQ7NamedElement[modifiedTestSuite.getItems().size()];
        int i = 0;
        while (i < modifiedTestSuite.getItems().size()) {
            IQ7NamedElement q7Element;
            content[i] = q7Element = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)modifiedTestSuite.getItems().get(i), scope);
            ++i;
        }
        return content;
    }

    public static ISearchScope getSearchScope(ITestSuite testSuite) {
        IQ7Project testSuiteProject = testSuite.getQ7Project();
        ISearchScope scope = testSuiteProject != null ? new ReferencedProjectScope(testSuiteProject) : new AllProjectScope();
        return scope;
    }
}

