/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.gen.ast.ScriptProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.util.internal.Plugin;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.utils.AdvancedInformationGenerator;
import org.eclipse.rcptt.verifications.status.EVerificationStatus;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;

public class ReportUtils {
    public static final Function<EObject, String> DEFAULT_DATUM_TO_MESSAGE = new Function<EObject, String>(){

        public String apply(EObject input) {
            if (input instanceof VerificationStatusData) {
                return ((VerificationStatusData)input).getMessage();
            }
            return "";
        }
    };

    public static Q7Statistics calculateStatistics(Iterable<Report> iterator) {
        return ReportUtils.calculateStatistics(iterator.iterator());
    }

    public static Q7Statistics calculateStatistics(Iterator<Report> iterator) {
        Q7Statistics statistics = ReportingFactory.eINSTANCE.createQ7Statistics();
        long startTime = Long.MAX_VALUE;
        long endTime = Long.MIN_VALUE;
        long totalTime = 0L;
        int total = 0;
        int failed = 0;
        int passed = 0;
        int skipped = 0;
        while (iterator.hasNext()) {
            Report report = iterator.next();
            if (report == null) continue;
            Node localRoot = report.getRoot();
            if (localRoot == null) {
                Plugin.UTILS.log((Throwable)new NullPointerException("Report should always have root"));
                continue;
            }
            ++total;
            Q7Info q7info = (Q7Info)localRoot.getProperties().get((Object)"q7");
            SimpleSeverity severity = SimpleSeverity.create((Q7Info)q7info);
            switch (severity) {
                case CANCEL: {
                    ++skipped;
                    break;
                }
                case ERROR: {
                    ++failed;
                    break;
                }
                case OK: {
                    ++passed;
                }
            }
            startTime = Math.min(startTime, localRoot.getStartTime());
            endTime = Math.max(endTime, localRoot.getEndTime());
            totalTime += localRoot.getDuration();
        }
        statistics.setTime((int)totalTime);
        statistics.setTotal(total);
        statistics.setFailed(failed);
        statistics.setPassed(passed);
        statistics.setSkipped(skipped);
        return statistics;
    }

    public static Report combineReports(Iterable<Report> reports, int len, IProgressMonitor monitor) {
        monitor.beginTask("Combine Q7 testcase reports", len * 10);
        Report report = ReportFactory.eINSTANCE.createReport();
        Node rootNode = ReportFactory.eINSTANCE.createNode();
        report.setRoot(rootNode);
        for (Report copy : reports) {
            HashMap<EventSource, EventSource> toUpdate = new HashMap<EventSource, EventSource>();
            EList copySources = copy.getSources();
            EList sources = report.getSources();
            ArrayList<EventSource> repSources = new ArrayList<EventSource>();
            for (EventSource source : copySources) {
                boolean exist = false;
                for (EventSource rootSource : sources) {
                    if (!ReportUtils.compareSources(source, rootSource)) continue;
                    toUpdate.put(source, rootSource);
                    exist = true;
                    break;
                }
                if (exist) continue;
                repSources.add(source);
            }
            sources.addAll(repSources);
            for (EventSource source : toUpdate.keySet()) {
                ReportUtils.updateSource(copy, source, (EventSource)toUpdate.get(source));
            }
            rootNode.getChildren().add((Object)copy.getRoot());
            monitor.worked(10);
        }
        monitor.done();
        return report;
    }

    private static boolean compareSources(EventSource source, EventSource rootSource) {
        if (source == null || rootSource == null) {
            return false;
        }
        EMap properties = source.getProperties();
        EMap properties2 = rootSource.getProperties();
        if (properties.size() != properties2.size()) {
            return false;
        }
        Set keySet = properties.keySet();
        for (String s : keySet) {
            EObject v2;
            EObject v1 = (EObject)properties.get((Object)s);
            if (EcoreUtil.equals((EObject)v1, (EObject)(v2 = (EObject)properties2.get((Object)s)))) continue;
            return false;
        }
        return true;
    }

    private static void updateSource(Report copy, EventSource source, EventSource rootSource) {
        TreeIterator contents = copy.eAllContents();
        ArrayList<Event> eventsToUpdate = new ArrayList<Event>();
        while (contents.hasNext()) {
            EventSource eSource;
            EObject next = (EObject)contents.next();
            if (!(next instanceof Event) || (eSource = ((Event)next).getSource()) == null || !source.equals(eSource)) continue;
            eventsToUpdate.add((Event)next);
        }
        for (Event event : eventsToUpdate) {
            event.setSource(rootSource);
        }
    }

    public static String getScenarioTags(Node item) {
        EList children = item.getChildren();
        for (Node node : children) {
            Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
            if (info == null || info.getType() != ItemKind.SCRIPT) continue;
            return info.getTags();
        }
        return "";
    }

    public static String getScenarioDescription(Node item) {
        EList children = item.getChildren();
        for (Node node : children) {
            Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
            if (info == null || info.getType() != ItemKind.SCRIPT) continue;
            return info.getDescription();
        }
        return null;
    }

    public static boolean isLoggedCommand(String name) {
        return ReportUtils.isTraceCommand(name) || ReportUtils.isScreenshotCommand(name);
    }

    public static boolean isTraceCommand(String name) {
        return name.equals("trace");
    }

    public static boolean isScreenshotCommand(String name) {
        return name.equals("take-screenshot");
    }

    public static final String formatTime(long duration) {
        return String.format("%d.%03d", duration / 1000L, duration % 1000L);
    }

    public static String replaceEscapeSymbols(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static List<Screenshot> findScreenshots(Node node) {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        ReportUtils.collectScreenshots(node, result);
        return result;
    }

    private static void collectScreenshots(Node node, List<Screenshot> acc) {
        for (Snaphot snapshot : node.getSnapshots()) {
            if (!(snapshot.getData() instanceof Screenshot)) continue;
            acc.add((Screenshot)snapshot.getData());
        }
        for (Node child : node.getChildren()) {
            ReportUtils.collectScreenshots(child, acc);
        }
    }

    public static ProcessStatus getStatus(Report report) {
        return ReportUtils.getStatus(report.getRoot());
    }

    public static ProcessStatus getStatus(Node item) {
        Q7Info current = (Q7Info)item.getProperties().get((Object)"q7");
        if (current == null) {
            return ProcessStatusConverter.toProcessStatus((IStatus)Status.error((String)"Non Q7 report node"));
        }
        return current.getResult();
    }

    public static String getFailMessage(Node item) {
        return ReportUtils.getFailMessage(ReportUtils.getStatus(item), true, DEFAULT_DATUM_TO_MESSAGE);
    }

    public static String getFailMessage(Node item, Function<EObject, String> datumToMessage) {
        Q7Info current = (Q7Info)item.getProperties().get((Object)"q7");
        if (current == null) {
            return "Non Q7 report node";
        }
        return ReportUtils.getFailMessage(current.getResult(), true, datumToMessage);
    }

    private static String getFailMessage(ProcessStatus result, boolean addExtra, Function<EObject, String> datumToMessage) {
        String childrenMessage;
        StringBuilder extraFailures = new StringBuilder();
        ProcessStatus firstFail = ReportUtils.getFirstFail((List<ProcessStatus>)result.getChildren(), extraFailures, datumToMessage);
        String resultMessage = ReportUtils.getDirectFailMessage(result, datumToMessage);
        if (firstFail != null && !resultMessage.equals(childrenMessage = ReportUtils.getFailMessage(firstFail, false, datumToMessage))) {
            String basePart = ReportUtils.getLineMessage(firstFail) + resultMessage + ": " + childrenMessage;
            if (addExtra) {
                String extraMsg = extraFailures.toString().replace(childrenMessage, "").replace("\n", " ");
                return basePart + " " + extraMsg;
            }
            return basePart;
        }
        if (addExtra) {
            String extraMsg = extraFailures.toString().replace(resultMessage, "").replace("\n", " ");
            return resultMessage + " " + extraMsg;
        }
        return resultMessage;
    }

    public static String getDirectFailMessage(ProcessStatus result, Function<EObject, String> datumToMessage) {
        StringBuilder sb = new StringBuilder(result.getMessage());
        if (result instanceof EVerificationStatus) {
            EVerificationStatus vs = (EVerificationStatus)result;
            sb.append("\n");
            sb.append(Joiner.on((String)"\n").join(Iterables.transform((Iterable)vs.getData(), datumToMessage)));
        }
        return sb.toString();
    }

    private static String getLineMessage(ProcessStatus firstFail) {
        if (firstFail.eContainer() instanceof ScriptProcessStatus) {
            return "Line " + ((ScriptProcessStatus)firstFail.eContainer()).getLine() + ": ";
        }
        return "";
    }

    private static ProcessStatus getFirstFail(List<ProcessStatus> children, StringBuilder extraFailures, Function<EObject, String> datumToMessage) {
        ProcessStatus result = null;
        for (ProcessStatus processStatus : children) {
            if (processStatus.getSeverity() == 0) continue;
            ProcessStatus grandChild = ReportUtils.getFirstFail((List<ProcessStatus>)processStatus.getChildren(), extraFailures, datumToMessage);
            if (result == null) {
                ProcessStatus processStatus2 = result = grandChild != null ? grandChild : processStatus;
            }
            if (result == grandChild) continue;
            extraFailures.append(ReportUtils.getFailMessage(processStatus, false, datumToMessage)).append(" ");
        }
        return result;
    }

    public static String replaceLineBreaks(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("\r\n", "<br />");
        string = string.replace("\n", "<br />");
        string = string.replace("\r", "<br />");
        return string;
    }

    public static String getHtmlPreformatted(String message) {
        return String.format("<pre>%s</pre>", message);
    }

    public static String getDetails(Node item) {
        StringBuilder builder = new StringBuilder();
        ReportUtils.collectDetails(item, builder);
        return ReportUtils.maskIllegalChars(builder.toString());
    }

    private static String maskIllegalChars(String str) {
        StringBuilder sb = new StringBuilder();
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isControl;
            char c = cArray[n2];
            boolean bl = isControl = c == '\t' || c == ' ' || c == '\r' || c == '\n' || c == '.' || c == ';' || c == ':' || c == '-' || c == '+' || c == '=' || c == '#' || c == '$' || c == '%' || c == '^' || c == '*' || c == '(' || c == ')' || c == '{' || c == '}' || c == '\"' || c == '\'' || c == '|' || c == '\\' || c == '/' || c == '<' || c == '>' || c == '!' || c == '@' || c == ',' || c == '_' || c == '[' || c == ']';
            if (!(Character.isLetterOrDigit(c) || isControl || Character.isAlphabetic(c))) {
                sb.append("(0x").append(Integer.toHexString(c)).append(")");
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString().replace("\u0000", "\\0").replace("]]>", "]] >");
    }

    public static String combineNames(EList<String> list, String separator) {
        if (list == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            sb.append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void collectDetails(Node item, StringBuilder result) {
        try {
            EList snapshots = item.getSnapshots();
            for (Snaphot snaphot : snapshots) {
                Iterator data = snaphot.getData();
                if (data == null) continue;
                if (data instanceof AdvancedInformation) {
                    StringWriter writer = new StringWriter();
                    new AdvancedInformationGenerator(new PrintWriter(writer)).writeAdvanced((AdvancedInformation)data, 0);
                    result.append(writer.toString()).append("\n");
                    continue;
                }
                new SimpleReportGenerator().toString((Appendable)result, 2, (EObject)data, new String[0]);
                result.append("\n");
            }
            EList events = item.getEvents();
            for (Event event : events) {
                if (!(event.getData() instanceof ProcessStatus)) continue;
                ProcessStatus data = (ProcessStatus)event.getData();
                new SimpleReportGenerator().toString((Appendable)result, 1, (EObject)data, new String[0]);
                result.append("\n");
            }
            EList children = item.getChildren();
            for (Node node : children) {
                ReportUtils.collectDetails(node, result);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getID(String value) {
        if (value == null) {
            return null;
        }
        Object textResult = "";
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            textResult = !Character.isLetterOrDigit(c) ? (String)textResult + "_" : (String)textResult + c;
            ++n2;
        }
        return textResult;
    }

    public static final String getTime(Node nde) {
        return ReportUtils.formatTime(nde.getDuration());
    }
}

