/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.internal.resources.Activator;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceData;

public class WorkspaceDataMaker {
    public void makeSelfSufficientData(WorkspaceData data, IPersistenceModel model, IQ7NamedElement source) throws ModelException {
        WSRoot root;
        if (model != null) {
            model.extractAll();
        }
        if ((root = data.getContent()) != null) {
            for (WSProject wsProject : root.getProjects()) {
                String location = source.getParent().getResource().getLocation().toString();
                this.fillFilesContent(wsProject.getFiles(), location, model);
                this.fillFileLinksContent(wsProject.getFileLinks());
                EList<WSFolder> folders = wsProject.getFolders();
                this.processFolders(folders, location, model);
                this.fillFolderLinksContent(wsProject.getFolderLinks(), model);
            }
            this.fillFolderLinksContent(root.getProjectLinks(), model);
        }
    }

    private void processFolders(EList<WSFolder> folders, String location, IPersistenceModel model) throws ModelException {
        for (WSFolder wsFolder : folders) {
            EList<WSFolder> list = wsFolder.getFolders();
            this.processFolders(list, location, model);
            EList<WSFile> files = wsFolder.getFiles();
            this.fillFilesContent(files, location, model);
            EList<WSFileLink> fileLinks = wsFolder.getFileLinks();
            this.fillFileLinksContent(fileLinks);
            this.fillFolderLinksContent(wsFolder.getFolderLinks(), model);
        }
    }

    private void fillFilesContent(EList<WSFile> files, String location, IPersistenceModel model) {
        for (WSFile wsFile : files) {
            this.fillFile(location, wsFile, model);
        }
    }

    private void fillFileLinksContent(EList<WSFileLink> fileLinks) throws ModelException {
        for (WSFileLink fileLink : fileLinks) {
            this.fillFileLink(fileLink);
        }
    }

    private <T extends WSFolderLink> void fillFolderLinksContent(EList<T> folderLinks, IPersistenceModel model) throws ModelException {
        for (WSFolderLink folderLink : folderLinks) {
            this.fillFolderLink(folderLink, model);
        }
    }

    private void fillFolderLink(WSFolderLink folderLink, IPersistenceModel model) throws ModelException {
        try {
            WSUtils.loadFolderLinkWithContent(folderLink);
        }
        catch (IOException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void fillFile(String location, WSFile wsFile, IPersistenceModel model) {
        try {
            byte[] content = WSUtils.getFileContent(location, wsFile, model);
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                zout.setLevel(9);
                zout.setMethod(8);
                ZipEntry entry = new ZipEntry("content");
                entry.setTime(1L);
                zout.putNextEntry(entry);
                zout.write(content);
                zout.close();
                wsFile.setContent(bout.toByteArray());
            } else {
                wsFile.setContent(content);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void fillFileLink(WSFileLink fileLink) throws ModelException {
        WSUtils.loadFileLinkWithContent(fileLink);
    }
}

