/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem;

import java.io.File;
import java.net.URL;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.filesystem.FSUtils;
import org.eclipse.rcptt.filesystem.FSCaptureParam;
import org.eclipse.rcptt.filesystem.FilesystemContext;
import org.eclipse.rcptt.filesystem.FilesystemFactory;
import org.eclipse.rcptt.util.FileSystemResolver;
import org.eclipse.rcptt.util.PrefixScheme;

public class FilesystemContextProcessor
implements IContextProcessor {
    private static final FileSystemResolver resolver = FilesystemContextProcessor.makeResolver();

    private static FileSystemResolver makeResolver() {
        File file2;
        URL url;
        FileSystemResolver resolver = new FileSystemResolver();
        Location location = Platform.getInstanceLocation();
        if (location != null && (url = location.getURL()) != null) {
            try {
                file2 = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("workspace://", file2.toString()));
            }
            catch (Exception file2) {
                // empty catch block
            }
        }
        if ((location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null) {
            try {
                file2 = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("aut://", file2.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("file://", null));
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("home://", new File(System.getProperty("user.home")).getAbsolutePath()));
        return resolver;
    }

    public boolean isApplied(Context context) {
        throw new UnsupportedOperationException();
    }

    public void apply(Context context, BooleanSupplier isCancelled) throws CoreException {
        FSUtils.apply((FilesystemContext)((FilesystemContext)context), (FileSystemResolver)resolver);
    }

    public Context create(EObject param) throws CoreException {
        FilesystemContext result = FilesystemFactory.eINSTANCE.createFilesystemContext();
        FSCaptureParam captureParam = (FSCaptureParam)param;
        FSUtils.capture((FilesystemContext)result, (String)(captureParam == null ? null : captureParam.getPath()), (FileSystemResolver)resolver);
        if (captureParam != null) {
            result.setPath(captureParam.getPath() == null ? "" : captureParam.getPath());
            result.setClear(captureParam.isClear());
        }
        return result;
    }
}

