/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class ShowSynchronizeParticipantAction
extends Action
implements IPropertyChangeListener {
    private final ISynchronizeParticipantReference fPage;
    private final ISynchronizeView fView;

    public void run() {
        try {
            if (!this.fPage.equals(this.fView.getParticipant())) {
                this.fView.display(this.fPage.getParticipant());
            }
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    public ShowSynchronizeParticipantAction(ISynchronizeView view, ISynchronizeParticipantReference ref) {
        super(Utils.shortenText(100, ref.getDisplayName()), 8);
        this.fPage = ref;
        this.fView = view;
        this.setImageDescriptor((ImageDescriptor)new ParticipantOverlay(ref));
        try {
            this.fPage.getParticipant().addPropertyChangeListener(this);
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("org.eclipse.team.pinned".equals(property) || "org.eclipse.team.schedule".equals(property)) {
            this.setImageDescriptor((ImageDescriptor)new ParticipantOverlay(this.fPage));
        }
    }

    private static final class ParticipantOverlay
    extends CompositeImageDescriptor {
        private final ImageData pinnedData = TeamUIPlugin.getImageDescriptor("ovr/pinned_ovr.png").getImageData();
        private final ImageData scheduledData = TeamUIPlugin.getImageDescriptor("ovr/waiting_ovr.png").getImageData();
        private ImageData imageData;
        private ISynchronizeParticipant participant;

        private ParticipantOverlay(ISynchronizeParticipantReference ref) {
            try {
                this.participant = ref.getParticipant();
                this.imageData = ref.getDescriptor().getImageDescriptor().getImageData();
            }
            catch (TeamException ex) {
                TeamUIPlugin.log((CoreException)((Object)ex));
            }
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.imageData, 0, 0);
            if (this.participant.isPinned()) {
                this.drawImage(this.pinnedData, this.imageData.width - this.pinnedData.width, 0);
            }
            if (this.participant instanceof SubscriberParticipant) {
                SubscriberParticipant participant = (SubscriberParticipant)this.participant;
                SubscriberRefreshSchedule schedule = participant.getRefreshSchedule();
                if (schedule != null && schedule.isEnabled()) {
                    this.drawImage(this.scheduledData, 0, 0);
                }
            } else {
                SubscriberRefreshSchedule schedule = (SubscriberRefreshSchedule)Adapters.adapt((Object)this.participant, SubscriberRefreshSchedule.class);
                if (schedule != null && schedule.isEnabled()) {
                    this.drawImage(this.scheduledData, 0, 0);
                }
            }
        }

        protected Point getSize() {
            return new Point(this.imageData.width, this.imageData.height);
        }
    }
}

