/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.launching.EquinoxLaunchConfiguration;

public class VMHelper {
    public static String getDefaultEEName(ILaunchConfiguration configuration) throws CoreException {
        LinkedList<IExecutionEnvironment> validEEs = new LinkedList<IExecutionEnvironment>();
        validEEs.addAll(Arrays.asList(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()));
        HashSet<String> unboundEEs = new HashSet<String>();
        Iterator iterator = validEEs.iterator();
        while (iterator.hasNext()) {
            IExecutionEnvironment current = (IExecutionEnvironment)iterator.next();
            if (current.getCompatibleVMs().length != 0) continue;
            iterator.remove();
            unboundEEs.add(current.getId());
        }
        boolean isOSGiLaunch = configuration instanceof EquinoxLaunchConfiguration;
        Set<IPluginModelBase> plugins = BundleLauncherHelper.getMergedBundleMap(configuration, isOSGiLaunch).keySet();
        for (IPluginModelBase plugin : plugins) {
            String[] bundleEnvs;
            BundleDescription desc;
            if (validEEs.isEmpty()) break;
            if (plugin.isFragmentModel() || (desc = plugin.getBundleDescription()) == null || (bundleEnvs = desc.getExecutionEnvironments()).length <= 0) continue;
            boolean isUnbound = false;
            String[] stringArray = bundleEnvs;
            int n = bundleEnvs.length;
            int n2 = 0;
            while (n2 < n) {
                String bundleEnv = stringArray[n2];
                if (unboundEEs.contains(bundleEnv)) {
                    isUnbound = true;
                    break;
                }
                ++n2;
            }
            if (isUnbound) continue;
            Iterator iterator2 = validEEs.iterator();
            while (iterator2.hasNext()) {
                IExecutionEnvironment currentEE = (IExecutionEnvironment)iterator2.next();
                boolean isValid = false;
                String[] stringArray2 = bundleEnvs;
                int n3 = bundleEnvs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IExecutionEnvironment[] currentSubEE;
                    String bundleEnv = stringArray2[n4];
                    if (isValid) break;
                    if (bundleEnv.equals(currentEE.getId())) {
                        isValid = true;
                        break;
                    }
                    IExecutionEnvironment[] iExecutionEnvironmentArray = currentSubEE = currentEE.getSubEnvironments();
                    int n5 = currentSubEE.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IExecutionEnvironment element = iExecutionEnvironmentArray[n6];
                        if (bundleEnv.equals(element.getId())) {
                            isValid = true;
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                if (isValid) continue;
                iterator2.remove();
            }
        }
        if (!validEEs.isEmpty()) {
            return ((IExecutionEnvironment)validEEs.iterator().next()).getId();
        }
        return null;
    }

    public static String getDefaultVMInstallName(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        IVMInstall vmInstall = null;
        if (javaProject != null) {
            vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        }
        if (vmInstall != null) {
            return vmInstall.getName();
        }
        return VMUtil.getDefaultVMInstallName();
    }

    public static IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String defaultVMName;
        IVMInstall vm;
        String jre = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        if (jre != null) {
            IPath jrePath = IPath.fromPortableString((String)jre);
            IVMInstall vm2 = JavaRuntime.getVMInstall((IPath)jrePath);
            if (vm2 == null) {
                String id = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
                if (id == null) {
                    String name = JavaRuntime.getVMInstallName((IPath)jrePath);
                    throw new CoreException(Status.error((String)NLS.bind((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)name)));
                }
                throw new CoreException(Status.error((String)NLS.bind((String)PDEMessages.VMHelper_cannotFindExecEnv, (Object)id)));
            }
            return vm2;
        }
        String eeId = VMHelper.getDefaultEEName(configuration);
        if (eeId != null) {
            IVMInstall vm3;
            IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId);
            String vmName = VMUtil.getVMInstallName((IExecutionEnvironment)ee);
            if (ee != null && (vm3 = VMUtil.getVMInstall((String)vmName)) != null) {
                return vm3;
            }
        }
        if ((vm = VMUtil.getVMInstall((String)(defaultVMName = VMHelper.getDefaultVMInstallName(configuration)))) != null) {
            return vm;
        }
        throw new CoreException(Status.error((String)NLS.bind((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)defaultVMName)));
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall launcher = VMHelper.getVMInstall(configuration);
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(Status.error((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_jrePathNotFound));
        }
        return launcher;
    }

    public static IRuntimeClasspathEntry getJREEntry(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre = VMHelper.createLauncher(configuration);
        IPath containerPath = IPath.fromOSString((String)JavaRuntime.JRE_CONTAINER);
        containerPath = containerPath.append(jre.getVMInstallType().getId());
        containerPath = containerPath.append(jre.getName());
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)containerPath, (int)2);
    }

    public static void addNewArgument(List<String> arguments, String key, String value) {
        if (arguments.stream().noneMatch(a -> a.startsWith(key + "="))) {
            arguments.add(key + "=" + value);
        }
    }
}

