/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import aQute.bnd.build.Container;
import aQute.bnd.build.Workspace;
import biz.aQute.resolve.Bndrun;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocation;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocationPage;
import org.eclipse.pde.internal.ui.bndtools.BndToolsMessages;
import org.eclipse.pde.internal.ui.bndtools.RunDescriptorTargetLocation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RunDescriptorTargetLocationPage
extends BndTargetLocationPage {
    private static final String FILE_EXTENSION = "bndrun";
    private RunDescriptorTargetLocation targetLocation;
    private IFile runDescriptorFile;
    private TreeViewer bundleList;

    public RunDescriptorTargetLocationPage(ITargetDefinition targetDefinition, RunDescriptorTargetLocation targetLocation) {
        super(BndToolsMessages.RunDescriptorTargetLocationPage_AddBndRunDescriptorContainer, BndToolsMessages.RunDescriptorTargetLocationPage_AddBndRunDescriptor, BndToolsMessages.RunDescriptorTargetLocationPage_Select, targetDefinition);
        if (targetLocation != null) {
            this.targetLocation = targetLocation;
            this.runDescriptorFile = targetLocation.getFile();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SWTFactory.createLabel(composite, BndToolsMessages.RunDescriptorTargetLocationPage_RunDescriptor, 1);
        TreeViewer projectTree = this.createRunDescriptorSelectionArea(composite);
        SWTFactory.createLabel(composite, BndToolsMessages.RunDescriptorTargetLocationPage_RunBundles, 1);
        this.bundleList = this.createBundleListArea(composite, 1);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.updateTarget();
        this.selectTargetInTree(projectTree);
        if (projectTree.getTree().getItems().length == 0) {
            this.logError("No run descriptors found in workspace", null);
        }
    }

    private TreeViewer createRunDescriptorSelectionArea(Composite composite) {
        TreeViewer projectTree = new TreeViewer(new Tree(composite, 2820));
        projectTree.getTree().setLayoutData(this.fillGridData(1));
        projectTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        projectTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        projectTree.setInput((Object)ResourcesPlugin.getWorkspace());
        projectTree.setFilters(this.getProjectTreeFilters());
        projectTree.addSelectionChangedListener(event -> {
            Object selection = ((ITreeSelection)event.getSelection()).getFirstElement();
            this.runDescriptorFile = selection != null && selection instanceof IFile ? (IFile)selection : null;
            this.updateTarget();
        });
        projectTree.expandAll();
        return projectTree;
    }

    private ViewerFilter[] getProjectTreeFilters() {
        PatternFilter bndrunFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                return element instanceof IFile && RunDescriptorTargetLocationPage.FILE_EXTENSION.equals(((IFile)element).getFileExtension());
            }

            public boolean isElementSelectable(Object element) {
                return element instanceof IFile;
            }
        };
        bndrunFilter.setPattern("*");
        return new ViewerFilter[]{bndrunFilter};
    }

    private void updateTarget() {
        if (this.runDescriptorFile == null) {
            this.clearTarget();
        } else {
            try {
                File file = this.runDescriptorFile.getRawLocation().makeAbsolute().toFile();
                Workspace workspace = BndTargetLocation.getWorkspace();
                ArrayList<CallSite> bundles = new ArrayList<CallSite>();
                Throwable throwable = null;
                Object var5_7 = null;
                try (Bndrun bndRun = new Bndrun(workspace, file);){
                    for (Container bundle : bndRun.getRunbundles()) {
                        bundles.add((CallSite)((Object)(bundle.getBundleSymbolicName() + " - " + bundle.getVersion())));
                    }
                    this.bundleList.setInput(bundles);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.setPageComplete(true);
                if (bundles.isEmpty()) {
                    this.logWarning("Run descriptor is empty: " + String.valueOf(this.runDescriptorFile.getFullPath()), null);
                } else {
                    this.resetMessage();
                }
            }
            catch (Exception e) {
                this.clearTarget();
                this.logError(e.getMessage(), e);
            }
        }
    }

    private void clearTarget() {
        this.runDescriptorFile = null;
        this.bundleList.setInput(Collections.emptySet());
        this.setPageComplete(false);
        this.resetMessage();
    }

    private boolean selectTargetInTree(TreeViewer projectTree) {
        if (this.runDescriptorFile == null) {
            return false;
        }
        TreeItem[] treeItemArray = projectTree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.setSelectedFileInTree(projectTree, item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean setSelectedFileInTree(TreeViewer projectTree, TreeItem item) {
        IFile file;
        if (item.getData() instanceof IFile && (file = (IFile)item.getData()).equals((Object)this.runDescriptorFile)) {
            projectTree.getTree().select(item);
            return true;
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (this.setSelectedFileInTree(projectTree, child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RunDescriptorTargetLocation getBundleContainer() {
        if (this.targetLocation == null) {
            this.targetLocation = new RunDescriptorTargetLocation();
        }
        return this.targetLocation.setRunDescriptor(this.runDescriptorFile);
    }
}

