/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.launching.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Capability implements Enumerator
{
    OTHER(0, "Other", "Other"),
    E4(2, "e4", "e4"),
    RAP(3, "rap", "rap");

    public static final int OTHER_VALUE = 0;
    public static final int E4_VALUE = 2;
    public static final int RAP_VALUE = 3;
    private static final Capability[] VALUES_ARRAY;
    public static final List<Capability> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Capability[]{OTHER, E4, RAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Capability get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Capability result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Capability getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Capability result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Capability get(int value) {
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 2: {
                return E4;
            }
            case 3: {
                return RAP;
            }
        }
        return null;
    }

    private Capability(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

