/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ua.ui.editor.toc.HelpEditorUtil;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;

public class TocDropAdapter
extends ViewerDropAdapter {
    private final TocTreeSection fSection;
    public static final int LOCATION_JUST_AFTER = 5;

    public TocDropAdapter(TreeViewer tocTree, TocTreeSection section) {
        super((Viewer)tocTree);
        this.fSection = section;
    }

    protected int determineLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)event.item;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.getViewer().getControl().toControl(coordinates);
        if (item != null) {
            Rectangle bounds = this.getBounds(item);
            if (bounds == null) {
                return 4;
            }
            if (coordinates.y - bounds.y < 5) {
                return 1;
            }
            if (bounds.y + bounds.height - coordinates.y < 5) {
                if (bounds.y - coordinates.y < 5) {
                    return 5;
                }
                return 2;
            }
        }
        return 3;
    }

    public void dragEnter(DropTargetEvent event) {
        this.validateFileDrop(event);
        this.setDNDMode(event);
    }

    public void dragOver(DropTargetEvent event) {
        int currentLocation = this.determineLocation(event);
        switch (currentLocation) {
            case 1: {
                event.feedback = 2;
                break;
            }
            case 2: 
            case 5: {
                event.feedback = 4;
                break;
            }
            default: {
                event.feedback = 1;
            }
        }
        event.feedback |= 0x18;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.validateFileDrop(event);
        this.setDNDMode(event);
    }

    private void setDNDMode(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = event.detail == 16 ? event.operations & 1 : (event.detail &= 1);
        } else if (!ModelDataTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
        }
    }

    private void validateFileDrop(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String[] fileNames;
            IBaseModel model = this.fSection.getPage().getModel();
            String[] stringArray = fileNames = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                IPath path = IPath.fromOSString((String)fileName);
                if (ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path) == null) {
                    event.detail = 0;
                    return;
                }
                if (!HelpEditorUtil.hasValidPageExtension(path) && !HelpEditorUtil.isTOCFile(path)) {
                    event.detail = 0;
                    return;
                }
                if (HelpEditorUtil.isCurrentResource(path, model)) {
                    event.detail = 0;
                    return;
                }
                ++n2;
            }
        }
    }

    public void drop(DropTargetEvent event) {
        int location;
        Object target = this.determineTarget(event);
        if (!this.fSection.performDrop(target, event.data, location = this.determineLocation(event))) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public boolean performDrop(Object data) {
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return false;
    }
}

