/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.network.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.raw.CloseConnection;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResetAssertSelection;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetFeature;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaMode;
import org.eclipse.rcptt.tesla.core.server.TeslaNetworkServer;
import org.eclipse.rcptt.tesla.internal.core.network.DataSerializer;
import org.eclipse.rcptt.tesla.internal.core.network.server.ITeslaNetworkClientProcessor;
import org.eclipse.rcptt.tesla.internal.core.network.server.NetworkTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.network.server.TeslaNetworkProcessorManager;

public class TeslaNetworkClientConnection
extends Thread {
    private final Socket socket;
    private final DataInputStream din;
    private final DataOutputStream dout;
    private boolean running = true;
    private TeslaMode mode = TeslaMode.FEATURES;
    private NetworkTeslaClient teslaClient;
    private ITeslaNetworkClientProcessor[] processors = new TeslaNetworkProcessorManager().getProcessors();
    private TeslaNetworkServer server;

    public TeslaNetworkClientConnection(Socket socket, TeslaNetworkServer server) throws IOException {
        super("Tesla network client connection:" + socket.getLocalPort());
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"network", (String)("Initialize runtime connection: " + socket.getLocalPort()));
        }
        this.socket = socket;
        this.server = server;
        this.din = new DataInputStream(socket.getInputStream());
        this.dout = new DataOutputStream(socket.getOutputStream());
        this.teslaClient = new NetworkTeslaClient(this.dout, Long.toString(this.getId()));
        ITeslaNetworkClientProcessor[] iTeslaNetworkClientProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaNetworkClientProcessor processor = iTeslaNetworkClientProcessorArray[n2];
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"network", (String)("Initialize processor: " + processor.getClass().getName()));
            }
            processor.initialize(this, this.din, this.dout, this.teslaClient);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (!TeslaFeatures.isActivityLogging()) ** GOTO lbl59
        Q7LoggingManager.logMessage((String)"network", (String)("Initialize connection to:" + this.socket.getLocalAddress().toString() + ":" + this.socket.getPort()));
        try {
            if (true) ** GOTO lbl59
            do {
                block28: {
                    object = DataSerializer.readEObject(this.din);
                    if (TeslaFeatures.isActivityLogging()) {
                        Q7LoggingManager.logMessage((String)"network", (String)("Read object: " + object.eClass().getName()));
                    }
                    if (!(object instanceof CloseConnection)) break block28;
                    this.terminate();
                    return;
                }
                try {
                    if (object instanceof SetMode) {
                        newMode = (SetMode)object;
                        if (TeslaFeatures.isActivityLogging()) {
                            Q7LoggingManager.logMessage((String)"network", (String)("set mode to: " + newMode.getMode().name()));
                        }
                        if (!this.mode.equals((Object)newMode.getMode())) {
                            var6_10 = this.processors;
                            var5_8 = this.processors.length;
                            var4_7 = 0;
                            while (var4_7 < var5_8) {
                                processor = var6_10[var4_7];
                                processor.activateMode((SetMode)object, this.mode);
                                ++var4_7;
                            }
                            this.mode = newMode.getMode();
                        }
                    }
                    if (object instanceof ResetAssertSelection) {
                        var5_9 = this.processors;
                        var4_7 = this.processors.length;
                        processor = 0;
                        while (processor < var4_7) {
                            processor = var5_9[processor];
                            processor.resetAssertSelection();
                            ++processor;
                        }
                    }
                    if (object instanceof Command) {
                        cmd = (Command)object;
                        this.teslaClient.addCommand(cmd);
                    }
                    if (object instanceof SetFeature) {
                        feature = (SetFeature)object;
                        var6_10 = this.processors;
                        var5_8 = this.processors.length;
                        var4_7 = 0;
                        while (var4_7 < var5_8) {
                            processor = var6_10[var4_7];
                            processor.setFeature(feature.getName(), feature.getValue());
                            ++var4_7;
                        }
                    }
                }
                catch (EOFException e) {
                    this.terminate();
                }
                catch (IOException e) {
                    if (this.running) {
                        e.printStackTrace();
                    }
                    this.terminate();
                }
                if (!this.running || this.socket == null) return;
            } while (!this.socket.isClosed());
            return;
        }
        finally {
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"network", (String)"Terminate client session");
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException var8_11) {}
            }
        }
    }

    private void terminate() {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"network", (String)"Terminate is called");
        }
        this.running = false;
        this.server.removeClient(this);
        boolean hasClients = this.server.hasClients();
        ITeslaNetworkClientProcessor[] iTeslaNetworkClientProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaNetworkClientProcessor processor = iTeslaNetworkClientProcessorArray[n2];
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"network", (String)("Terminate processor:" + processor.getClass().getName()));
            }
            processor.terminate(!hasClients);
            ++n2;
        }
    }

    public void shutdown() {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"network", (String)"Shotdown is called");
        }
        if (this.running) {
            this.terminate();
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

