/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.wizards.imports.ProjectRecord;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class BaseProjectsImportPage
extends WizardPage
implements IOverwriteQuery {
    public static final String METADATA_FOLDER = ".metadata";
    protected ILeveledImportStructureProvider structureProvider;
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    private Text directoryPathField;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Text archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String lastPath;
    private long lastModified;
    private String initialPath;

    public BaseProjectsImportPage() {
        this(null);
    }

    public BaseProjectsImportPage(String initialPath) {
        super("wizardExternalProjectsPage");
        this.initialPath = initialPath;
        this.setPageComplete(false);
        this.setTitle(Messages.BaseProjectsImportPage_Title);
        this.setDescription(Messages.BaseProjectsImportPage_Description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(Messages.BaseProjectsImportPage_ProjectsLabel);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return BaseProjectsImportPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts) {
                    BaseProjectsImportPage.this.projectsList.setChecked((Object)element, false);
                }
                BaseProjectsImportPage.this.setPageComplete(BaseProjectsImportPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(Messages.BaseProjectsImportPage_SelectAllButton);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < BaseProjectsImportPage.this.selectedProjects.length) {
                    if (BaseProjectsImportPage.this.selectedProjects[i].hasConflicts) {
                        BaseProjectsImportPage.this.projectsList.setChecked((Object)BaseProjectsImportPage.this.selectedProjects[i], false);
                    } else {
                        BaseProjectsImportPage.this.projectsList.setChecked((Object)BaseProjectsImportPage.this.selectedProjects[i], true);
                    }
                    ++i;
                }
                BaseProjectsImportPage.this.setPageComplete(BaseProjectsImportPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(Messages.BaseProjectsImportPage_DeselectAllButton);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProjectsImportPage.this.projectsList.setCheckedElements(new Object[0]);
                BaseProjectsImportPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(Messages.BaseProjectsImportPage_RefreshButton);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.directoryPathField.getText().trim());
                } else {
                    BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(Messages.BaseProjectsImportPage_SelectRootDirRadioButton);
        this.directoryPathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(Messages.BaseProjectsImportPage_BrowseButton);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(Messages.BaseProjectsImportPage_SelectArchiveFileRagioButton);
        this.archivePathField = new Text(projectGroup, 2048);
        GridData archivePathData = new GridData(4, 0, true, false);
        archivePathData.widthHint = new PixelConverter((Control)this.archivePathField).convertWidthInCharsToPixels(25);
        this.archivePathField.setLayoutData((Object)archivePathData);
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(Messages.BaseProjectsImportPage_BrowseButton);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProjectsImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProjectsImportPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BaseProjectsImportPage.this.updateProjectsList(BaseProjectsImportPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProjectsImportPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProjectsImportPage.this.archiveRadioSelected();
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.setMessage(Messages.BaseProjectsImportPage_NoDirSpecifiedMsg);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.BaseProjectsImportPage_12, 100);
                    BaseProjectsImportPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList<Object> files = new ArrayList<Object>();
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isTarFile((String)path)) {
                        TarFile sourceTarFile = BaseProjectsImportPage.this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile == null) {
                            return;
                        }
                        BaseProjectsImportPage.this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                        Object child = BaseProjectsImportPage.this.structureProvider.getRoot();
                        if (!BaseProjectsImportPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        BaseProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(Messages.BaseProjectsImportPage_13);
                        while (filesIterator.hasNext()) {
                            BaseProjectsImportPage.this.selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (!dirSelected && ArchiveFileManipulations.isZipFile((String)path)) {
                        ZipFile sourceFile = BaseProjectsImportPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            return;
                        }
                        BaseProjectsImportPage.this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                        Object child = BaseProjectsImportPage.this.structureProvider.getRoot();
                        if (!BaseProjectsImportPage.this.collectProjectFilesFromProvider(files, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        BaseProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(Messages.BaseProjectsImportPage_14);
                        while (filesIterator.hasNext()) {
                            BaseProjectsImportPage.this.selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        if (!BaseProjectsImportPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        BaseProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(Messages.BaseProjectsImportPage_15);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            BaseProjectsImportPage.this.selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Q7UIPlugin.log(e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasConflicts) {
                displayWarning = true;
                this.projectsList.setGrayed((Object)projects[i], true);
            } else {
                this.projectsList.setChecked((Object)projects[i], true);
            }
            ++i;
        }
        if (displayWarning) {
            this.setMessage(Messages.BaseProjectsImportPage_16, 2);
        } else {
            this.setMessage(Messages.BaseProjectsImportPage_17);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(Messages.BaseProjectsImportPage_18, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException e) {
            this.displayErrorDialog(Messages.BaseProjectsImportPage_19);
        }
        catch (IOException e) {
            this.displayErrorDialog(Messages.BaseProjectsImportPage_20);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException e) {
            this.displayErrorDialog(Messages.BaseProjectsImportPage_21);
        }
        catch (IOException e) {
            this.displayErrorDialog(Messages.BaseProjectsImportPage_22);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message, (int)0x10000000);
    }

    protected String getErrorDialogTitle() {
        return Messages.BaseProjectsImportPage_23;
    }

    private boolean collectProjectFilesFromDirectory(Collection<Object> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)Messages.BaseProjectsImportPage_24, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        String dotProject = ".project";
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection<Object> files, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)Messages.BaseProjectsImportPage_25, (Object)this.structureProvider.getLabel(entry)));
        ArrayList children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        for (Object child : children) {
            String elementLabel;
            if (this.structureProvider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, child, level + 1, monitor);
            }
            if (!(elementLabel = this.structureProvider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(this.structureProvider, child, entry, level));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(Messages.BaseProjectsImportPage_26);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(Messages.BaseProjectsImportPage_27);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        BaseProjectsImportPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = Messages.BaseProjectsImportPage_28;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.rcptt.ui", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
        return true;
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    protected abstract boolean createExistingProject(ProjectRecord var1, IProgressMonitor var2) throws InvocationTargetException, InterruptedException;

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)Messages.BaseProjectsImportPage_29, (Object)pathString) : NLS.bind((String)Messages.BaseProjectsImportPage_30, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), Messages.BaseProjectsImportPage_31, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.isProjectExists(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].hasConflicts = true;
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    protected abstract boolean isProjectExists(String var1);

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.initialPath == null && settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean dir = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(dir);
            this.projectFromArchiveRadio.setSelection(!dir);
            if (dir) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(this.initialPath.length());
                this.directoryRadioSelected();
            } else {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(this.initialPath.length());
                this.archiveRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts) {
                return BaseProjectsImportPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }
}

