/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;

class LocalFileHandle
implements ResourceHandle {
    private final Path path;

    public LocalFileHandle(Path path) {
        this.path = path;
    }

    public String info() {
        return this.path.toAbsolutePath().toString();
    }

    public void write(byte[] content) throws Exception {
        File file = this.path.toFile();
        file.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(content);
            out.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public byte[] content() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream stream = new FileInputStream(this.path.toFile());){
            return stream.readAllBytes();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

