/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workspace;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.loc.internal.api.workspace.Keys;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.workspace.DomainFileExtension;
import org.eclipse.passage.loc.workspace.LocalFileHandle;

final class HomeBasedKeys
implements Keys {
    private final Path residence;
    private final PassageFileExtension keys = new DomainFileExtension.Keys();
    private final PassageFileExtension pub = new PassageFileExtension.PublicKey();

    HomeBasedKeys() {
        this.residence = new LicensingFolder((Supplier)new UserHomePath()).get();
    }

    public Optional<String> existing(String product, String version) {
        return this.reportExistance(this.residentFile(product, version, this.keys));
    }

    public ResourceHandle located(String product, String version) {
        return new LocalFileHandle(this.residentFile(product, version, this.keys));
    }

    public ResourceHandle locatedPub(String product, String version) {
        return new LocalFileHandle(this.residentFile(product, version, this.pub));
    }

    private Path residentFile(String product, String version, PassageFileExtension ext) {
        return this.productResidence(product, version).resolve(this.fileForProduct(product, version, ext));
    }

    private Optional<String> reportExistance(Path file) {
        return Files.exists(file, new LinkOption[0]) ? Optional.of(file.toAbsolutePath().toString()) : Optional.empty();
    }

    private String fileForProduct(String product, String version, PassageFileExtension ext) {
        return new FileNameFromLicensedProduct(product, version, ext).get();
    }

    private Path productResidence(String product, String version) {
        return new PathFromLicensedProduct(() -> this.residence, product, version).get();
    }
}

