/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Date;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.licenses.model.EmptyPersonalLicensePack;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriod;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicenseGrantFromRequest;

final class PersonalLicensePackFromRequest
implements Supplier<PersonalLicensePack> {
    private final PersonalLicenseRequest request;
    private final LicenseRegistry licenses;

    PersonalLicensePackFromRequest(PersonalLicenseRequest request, LicenseRegistry licesnses) {
        this.request = request;
        this.licenses = licesnses;
    }

    @Override
    public PersonalLicensePack get() {
        PersonalLicensePack pack = new EmptyPersonalLicensePack().get();
        this.installRequisites(pack);
        this.installGrants(pack);
        return pack;
    }

    private void installRequisites(PersonalLicensePack pack) {
        pack.getLicense().setIdentifier(this.request.identifier());
        pack.getLicense().setIssueDate(new Date());
        pack.getLicense().getUser().setIdentifier(this.request.user());
        pack.getLicense().getUser().setName(this.request.userFullName());
        pack.getLicense().getProduct().setIdentifier(this.request.productIdentifier());
        pack.getLicense().getProduct().setVersion(this.request.productVersion());
        pack.getLicense().setPlan(this.request.plan());
        pack.getLicense().setValid(this.valid());
    }

    private void installGrants(PersonalLicensePack pack) {
        LicensePlanDescriptor plan = this.licenses.getLicensePlan(pack.getLicense().getPlan());
        for (LicensePlanFeatureDescriptor feature : plan.getFeatures()) {
            pack.getGrants().add((Object)new LicenseGrantFromRequest(feature, this.request).get());
        }
    }

    private ValidityPeriod valid() {
        ValidityPeriodClosed valid = LicensesFactory.eINSTANCE.createValidityPeriodClosed();
        valid.setFrom(this.request.validFrom());
        valid.setUntil(this.request.validUntil());
        return valid;
    }
}

