/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.issue;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.UserGrant;
import org.eclipse.passage.loc.internal.licenses.core.i18n.ReductionMessages;
import org.eclipse.passage.loc.internal.licenses.core.issue.Reduction;

final class UserGrantsAmountReduction
implements Reduction<FloatingLicensePack> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final int amount = 5;

    UserGrantsAmountReduction() {
    }

    @Override
    public void accept(FloatingLicensePack license) {
        EList users = license.getUsers();
        if (users.size() > 5) {
            this.log.warn(String.format(ReductionMessages.UserGrantsAmountReduction_reduction_usergrant_amount, 5));
            int i = users.size() - 1;
            while (i >= 5) {
                UserGrant victim = (UserGrant)users.remove(i);
                this.log.warn(String.format(ReductionMessages.UserGrantsAmountReduction_reduction_usergrant_user, victim.getUser()));
                --i;
            }
        }
    }
}

