/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.Restriction;

final class LicensingOperatorRequirement
implements Supplier<Optional<Requirement>> {
    private final ExaminationCertificate certificate;
    private final LicensedProduct operator;

    LicensingOperatorRequirement(ExaminationCertificate certificate, LicensedProduct operator) {
        this.certificate = certificate;
        this.operator = operator;
    }

    @Override
    public Optional<Requirement> get() {
        return this.satisfiedOperatorRequirement().or(this::unsatisfiedOperatorRequirement);
    }

    private Optional<Requirement> satisfiedOperatorRequirement() {
        return this.certificate.satisfied().stream().filter(this::describesOperator).findAny();
    }

    private Optional<Requirement> unsatisfiedOperatorRequirement() {
        return this.certificate.restrictions().stream().map(Restriction::unsatisfiedRequirement).filter(this::describesOperator).findAny();
    }

    private boolean describesOperator(Requirement requirement) {
        return requirement.feature().identifier().equals(this.operator.identifier());
    }
}

