/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.passage.lic.emf.validation.ErrorMessages;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.UserHomeProductResidence;
import org.eclipse.passage.lic.internal.licenses.model.AssignGrantIdentifiers;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseEvents;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.BaseIssuedLicense;
import org.eclipse.passage.loc.internal.licenses.core.LicenseSignature;
import org.eclipse.passage.loc.internal.licenses.core.PersistedDecoded;
import org.eclipse.passage.loc.internal.licenses.core.PersistedEncoded;
import org.eclipse.passage.loc.internal.licenses.core.ProductPassword;
import org.eclipse.passage.loc.internal.licenses.core.UpdateLicensePlan;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.eclipse.passage.loc.internal.licenses.core.issue.PersonalLicenseIssuingProtection;
import org.eclipse.passage.loc.internal.licenses.trouble.code.LicenseIssuingFailed;
import org.eclipse.passage.loc.internal.licenses.trouble.code.LicenseValidationFailed;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.osgi.service.event.EventAdmin;

final class IssuePersonalLicense {
    private final LicenseRegistry licenses;
    private final ProductRegistry products;
    private final OperatorProductService operator;
    private final EventAdmin events;

    IssuePersonalLicense(LicenseRegistry licenses, ProductRegistry products, OperatorProductService operator, EventAdmin events) {
        this.licenses = licenses;
        this.products = products;
        this.operator = operator;
        this.events = events;
    }

    ServiceInvocationResult<IssuedLicense> issue(Supplier<PersonalLicensePack> template) {
        Path encrypted;
        Path decrypted;
        PersonalLicensePack license = this.adjsut(this.signed((PersonalLicensePack)EcoreUtil.copy((EObject)template.get())));
        Optional errors = new ErrorMessages().apply((EObject)license);
        if (errors.isPresent()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseValidationFailed(), (String)errors.get()));
        }
        try {
            new UpdateLicensePlan(this.licenses).withPersonal((PersonalLicensePack)EcoreUtil.copy((EObject)license));
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_error_io, (Exception)e));
        }
        BaseLicensedProduct product = new BaseLicensedProduct(license.getLicense().getProduct().getIdentifier(), license.getLicense().getProduct().getVersion());
        Path path = new UserHomeProductResidence((LicensedProduct)product).get();
        try {
            decrypted = new PersistedDecoded(path, (EObject)license).write(String.valueOf(license.getLicense().getIdentifier()) + new PassageFileExtension.LicenseDecrypted().get());
            this.events.postEvent(OperatorLicenseEvents.decodedIssued((String)decrypted.toString()));
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_failed_to_save_decoded, (Exception)((Object)e)));
        }
        try {
            encrypted = new PersistedEncoded((LicensedProduct)product, decrypted, new ProductPassword(this.products, this.operator)).write(String.valueOf(license.getLicense().getIdentifier()) + new PassageFileExtension.LicenseEncrypted().get());
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_export_error, (Exception)((Object)e)));
        }
        this.events.postEvent(OperatorLicenseEvents.encodedIssued((String)encrypted.toString()));
        return new BaseServiceInvocationResult((Object)new BaseIssuedLicense(license, encrypted, decrypted));
    }

    private PersonalLicensePack adjsut(PersonalLicensePack license) {
        Date issueDate = new Date();
        license.getLicense().setIdentifier(UUID.randomUUID().toString());
        license.getLicense().setIssueDate(issueDate);
        new AssignGrantIdentifiers().accept(license);
        new PersonalLicenseIssuingProtection().accept(license);
        return license;
    }

    private PersonalLicensePack signed(PersonalLicensePack pack) {
        new LicenseSignature().accept((LicenseRequisites)pack.getLicense());
        return pack;
    }
}

