/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.loc.internal.workbench.ClassifierMetadata;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizardPage;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class RootClassifierWizardPage
extends BaseClassifierWizardPage {
    private final String extension;
    protected Text text;
    private Button button;

    protected RootClassifierWizardPage(ClassifierMetadata metadata, ClassifierInitializer initializer, String extension) {
        super(RootClassifierWizardPage.class.getSimpleName(), metadata, initializer);
        this.extension = extension;
    }

    @Override
    protected void createFieldControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.CreateFileWizardPage_label_file);
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.text.addModifyListener(this.validator);
        this.button = new Button(composite, 8);
        this.button.setText(WorkbenchMessages.CreateFileWizardPage_button_browse);
        this.button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectPath()));
        super.createFieldControls(composite);
    }

    protected void selectPath() {
        String selected = LocWokbench.selectSavePath(this.getShell(), this.extension);
        if (selected != null) {
            this.text.setText(selected);
        }
    }

    @Override
    protected void initControls(ClassifierInitializer initializer) {
        super.initControls(initializer);
        this.text.setText(String.valueOf(this.basePath()) + File.separator + initializer.newFileName() + '.' + this.extension);
    }

    protected String basePath() {
        return System.getProperty("user.home");
    }

    protected String path() {
        String path = this.text.getText();
        if (!path.endsWith(String.valueOf('.') + this.extension)) {
            path = String.valueOf(path) + '.' + this.extension;
        }
        return path;
    }

    @Override
    protected boolean validatePage() {
        if (this.path().isEmpty()) {
            this.setMessage(WorkbenchMessages.CreateFileWizardPage_e_specify_path);
            return false;
        }
        return super.validatePage();
    }
}

