/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.loc.internal.workbench.ClassifierMetadata;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizard;
import org.eclipse.swt.widgets.Shell;

public abstract class CreateClassifier<C>
implements Supplier<Optional<C>> {
    private final IEclipseContext context;
    private final String domain;
    private final Class<C> classifierClass;

    public CreateClassifier(IEclipseContext context, String domain, Class<C> classifier) {
        Objects.requireNonNull(context, WorkbenchMessages.CreateDomainResource_e_null_context);
        Objects.requireNonNull(domain, WorkbenchMessages.CreateDomainResource_e_null_domain);
        Objects.requireNonNull(classifier, WorkbenchMessages.CreateDomainResource_e_null_classifier);
        this.context = context;
        this.domain = domain;
        this.classifierClass = classifier;
    }

    @Override
    public Optional<C> get() {
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)this.context.get(EditingDomainRegistryAccess.class);
        ClassifierInitializer initializer = registryAccess.getClassifierInitializer(this.domain);
        EditingDomainRegistry registry = registryAccess.getDomainRegistry(this.domain);
        return this.showWizard(initializer, registry).filter(this.classifierClass::isInstance).flatMap(e -> Optional.of(this.classifierClass.cast(e)));
    }

    protected Optional<EObject> showWizard(ClassifierInitializer initializer, EditingDomainRegistry<?> registry) {
        ClassifierMetadata metadata = new ClassifierMetadata(registry.getContentClassifier(), registry.getContentIdentifierAttribute(), registry.getContentNameAttribute());
        BaseClassifierWizard<?> wizard = this.createWizard(metadata, initializer, registry);
        WizardDialog dialog = new WizardDialog((Shell)this.context.get(Shell.class), wizard);
        dialog.create();
        dialog.setTitle(initializer.newObjectTitle());
        dialog.setMessage(initializer.newFileMessage());
        Shell createdShell = dialog.getShell();
        createdShell.setText(initializer.newObjectMessage());
        createdShell.setImage(LicensingImages.getImage((String)registry.getContentClassifier().getName()));
        dialog.open();
        return wizard.created();
    }

    protected abstract BaseClassifierWizard<?> createWizard(ClassifierMetadata var1, ClassifierInitializer var2, EditingDomainRegistry<?> var3);
}

