/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.DirtyRegionQueue;

class ReconcilerJob
extends Job {
    private boolean fCanceled = false;
    private boolean fReset = false;
    private boolean fIsDirty = false;
    private boolean fIsActive = false;
    private volatile boolean fIsAlive;
    private boolean started;
    private AbstractReconciler fReconciler;

    public ReconcilerJob(String name, AbstractReconciler reconciler) {
        super(name);
        this.fReconciler = reconciler;
        this.setPriority(50);
        this.setSystem(true);
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public synchronized boolean isDirty() {
        return this.fIsDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        this.fCanceled = true;
        IProgressMonitor pm = this.fReconciler.getProgressMonitor();
        if (pm != null) {
            pm.setCanceled(true);
        }
        DirtyRegionQueue dirtyRegionQueue = this.fReconciler.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            this.fReconciler.fDirtyRegionQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendCallerWhileDirty() {
        boolean isDirty;
        this.fReconciler.signalWaitForFinish();
        do {
            DirtyRegionQueue dirtyRegionQueue = this.fReconciler.fDirtyRegionQueue;
            synchronized (dirtyRegionQueue) {
                boolean bl = isDirty = this.fReconciler.fDirtyRegionQueue.getSize() > 0;
                if (isDirty) {
                    try {
                        this.fReconciler.fDirtyRegionQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (isDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object;
        if (this.fReconciler.fDelay > 0) {
            object = this;
            synchronized (object) {
                this.fIsDirty = true;
                this.fReset = true;
            }
            object = this.fReconciler.fDirtyRegionQueue;
            synchronized (object) {
                this.fReconciler.fDirtyRegionQueue.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            this.fIsDirty = true;
        }
        object = this.fReconciler.fDirtyRegionQueue;
        synchronized (object) {
            this.fReconciler.fDirtyRegionQueue.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.started = false;
        }
        this.fReconciler.informNotFinished();
        this.fReconciler.reconcilerReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        this.fIsAlive = true;
        this.fReconciler.delay();
        if (this.fCanceled) {
            return Status.CANCEL_STATUS;
        }
        this.fReconciler.initialProcess();
        while (!this.fCanceled) {
            this.fReconciler.delay();
            if (this.fCanceled) break;
            if (!this.isDirty()) {
                this.fReconciler.waitFinish = false;
                continue;
            }
            ReconcilerJob reconcilerJob = this;
            synchronized (reconcilerJob) {
                if (this.fReset) {
                    this.fReset = false;
                    continue;
                }
            }
            DirtyRegion r = null;
            DirtyRegionQueue dirtyRegionQueue = this.fReconciler.fDirtyRegionQueue;
            synchronized (dirtyRegionQueue) {
                r = this.fReconciler.fDirtyRegionQueue.removeNextDirtyRegion();
            }
            this.fIsActive = true;
            this.fReconciler.getProgressMonitor().setCanceled(false);
            this.fReconciler.process(r);
            dirtyRegionQueue = this.fReconciler.fDirtyRegionQueue;
            synchronized (dirtyRegionQueue) {
                if (this.fReconciler.fDirtyRegionQueue.getSize() == 0) {
                    ReconcilerJob reconcilerJob2 = this;
                    synchronized (reconcilerJob2) {
                        this.fIsDirty = this.fReconciler.getProgressMonitor().isCanceled();
                    }
                    this.fReconciler.fDirtyRegionQueue.notifyAll();
                }
            }
            this.fIsActive = false;
        }
        this.fIsAlive = false;
        return Status.OK_STATUS;
    }

    public boolean isAlive() {
        return this.fIsAlive;
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.schedule();
        }
    }

    public boolean belongsTo(Object family) {
        return family == this.fReconciler.getTextViewer() || AbstractReconciler.class == family;
    }
}

