/*******************************************************************************
 * Copyright (c) 2010 itemis AG (http://www.itemis.eu) and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.xtext.xbase.interpreter.impl;

import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;

/**
 * @author Sebastian Zarnekow - Initial contribution and API
 */
public class NullEvaluationContext implements IEvaluationContext {

	@Override
	public Object getValue(QualifiedName qualifiedName) {
		return null;
	}

	@Override
	public void newValue(QualifiedName qualifiedName, Object value) {
		throw new IllegalStateException("Cannot create new value in null context.");
	}

	@Override
	public void assignValue(QualifiedName qualifiedName, Object value) {
		throw new IllegalStateException("Cannot assign a value in null context.");
	}

	@Override
	public IEvaluationContext fork() {
		throw new IllegalStateException("Cannot fork a null context.");
	}

}
