/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.ui.document.DocumentRewriter;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.NewFeatureNameUtil;

public class ExtractVariableRefactoring
extends Refactoring {
    public static final Logger LOG = Logger.getLogger(ExtractVariableRefactoring.class);
    @Inject
    private Provider<StatusWrapper> statusProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ExpressionUtil expressionUtil;
    @Inject
    private NewFeatureNameUtil nameUtil;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private DocumentRewriter.Factory rewriterFactory;
    @Inject
    private ReplaceConverter replaceConverter;
    private IXtextDocument document;
    private XExpression expression;
    private String variableName;
    private boolean isFinal = true;
    private URI resourceURI;
    private boolean isNeedsNewBlock;
    private XExpression successor;
    private DocumentRewriter rewriter;
    private XtextEditor editor;

    public boolean initialize(XtextEditor editor, XExpression expression) {
        this.editor = editor;
        this.document = editor.getDocument();
        this.expression = expression;
        this.resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)expression).trimFragment();
        this.successor = this.expressionUtil.findSuccessorExpressionForVariableDeclaration((EObject)expression);
        if (this.successor == null) {
            return false;
        }
        this.isNeedsNewBlock = !(this.successor.eContainer() instanceof XBlockExpression);
        this.nameUtil.setFeatureScopeContext(this.successor);
        this.variableName = this.nameUtil.getDefaultName(expression);
        this.rewriter = this.rewriterFactory.create(this.document, (XtextResource)expression.eResource());
        return true;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public RefactoringStatus validateNewVariableName(String newVariableName) {
        RefactoringStatus status = new RefactoringStatus();
        this.nameUtil.checkNewFeatureName(newVariableName, true, status);
        return status;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getName() {
        return "Extract Local Variable Refactoring";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        return status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        try {
            String expressionExpanded;
            status.merge(this.validateNewVariableName(this.variableName));
            ITextRegion expressionRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.expression);
            ITextRegion successorRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.successor);
            DocumentRewriter.Section callerSection = this.rewriter.newSection(expressionRegion.getOffset(), expressionRegion.getLength());
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.isNeedsNewBlock) {
                IRegion lineInformation = this.document.getLineInformationOfOffset(successorRegion.getOffset());
                int previousLineEnd = lineInformation.getOffset() - this.rewriter.getLineSeparator().length();
                DocumentRewriter.Section blockStartSection = this.getDeclarationSection(Math.max(0, previousLineEnd), expressionRegion.getOffset(), callerSection);
                if (previousLineEnd > 0 && !Character.isWhitespace(this.document.getChar(previousLineEnd - 1))) {
                    blockStartSection.append(" ");
                }
                blockStartSection.append("{").increaseIndentation().newLine();
                this.appendDeclaration(blockStartSection, expressionRegion);
                DocumentRewriter.Section blockEndSection = this.rewriter.newSection(successorRegion.getOffset() + successorRegion.getLength(), 0);
                blockEndSection.decreaseIndentation().newLine().append((CharSequence)"}");
            } else {
                DocumentRewriter.Section declarationSection = this.getDeclarationSection(successorRegion.getOffset(), expressionRegion.getOffset(), callerSection);
                this.appendDeclaration(declarationSection, expressionRegion);
                declarationSection.newLine();
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Object callerText = this.variableName;
            if (!(!(this.expression.eContainer() instanceof XMemberFeatureCall) || ((XMemberFeatureCall)this.expression.eContainer()).getMemberCallArguments().size() != 1 || (expressionExpanded = this.document.get(expressionRegion.getOffset() - 1, expressionRegion.getLength() + 2)).startsWith("(") && expressionExpanded.endsWith(")"))) {
                callerText = "(" + (String)callerText + ")";
            }
            callerSection.append((CharSequence)callerText);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    protected DocumentRewriter.Section getDeclarationSection(int declarationOffset, int callerOffset, DocumentRewriter.Section callerSection) {
        if (callerOffset == declarationOffset) {
            return callerSection;
        }
        return this.rewriter.newSection(declarationOffset, 0);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        TextEdit textEdit = this.replaceConverter.convertToTextEdit(this.rewriter.getChanges());
        EditorDocumentChange change = new EditorDocumentChange("Extract local variable", (ITextEditor)this.editor, false);
        change.setEdit(textEdit);
        change.setTextType(this.resourceURI.fileExtension());
        return change;
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    protected void appendDeclaration(ISourceAppender section, ITextRegion expressionRegion) throws BadLocationException {
        section.append((CharSequence)(this.isFinal ? "val" : "var")).append((CharSequence)" ").append((CharSequence)this.variableName).append((CharSequence)" = ");
        String expressionAsString = this.document.get(expressionRegion.getOffset(), expressionRegion.getLength());
        if (this.expression instanceof XClosure) {
            XClosure closure = (XClosure)this.expression;
            if (expressionAsString.startsWith("[") && expressionAsString.endsWith("]")) {
                expressionAsString = expressionAsString.substring(1, expressionAsString.length() - 1);
            }
            section.append((CharSequence)"[");
            boolean isFirst = true;
            if (!closure.getFormalParameters().isEmpty()) {
                IResolvedTypes types = this.typeResolver.resolveTypes((EObject)closure);
                for (JvmFormalParameter parameter : closure.getFormalParameters()) {
                    if (!isFirst) {
                        section.append((CharSequence)", ");
                    }
                    isFirst = false;
                    LightweightTypeReference parameterType = types.getActualType((JvmIdentifiableElement)parameter);
                    section.append(parameterType);
                    section.append((CharSequence)" ").append((CharSequence)parameter.getIdentifier());
                }
            }
            section.append((CharSequence)" | ");
            if (!closure.getDeclaredFormalParameters().isEmpty()) {
                section.append((CharSequence)expressionAsString.substring(expressionAsString.indexOf("|") + 1));
            } else {
                section.append((CharSequence)expressionAsString);
            }
            section.append((CharSequence)"]");
        } else {
            section.append((CharSequence)expressionAsString);
        }
    }
}

